/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.SocketConnectionFactory;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.net.ThreadPool;
import org.sapia.ubik.net.UbikServerSocketFactory;
import org.sapia.ubik.rmi.server.perf.Statistic;

public abstract class SocketServer
implements Runnable {
    private ServerSocket _server;
    protected SocketConnectionFactory _fac;
    private String _address;
    private ThreadPool _tp;
    private boolean _started;
    private SocketException _startExc;

    protected SocketServer(int port, ThreadPool tp, UbikServerSocketFactory socketFactory) throws IOException {
        this(port, new SocketConnectionFactory(), tp, socketFactory);
    }

    protected SocketServer(String bindAddr, int port, ThreadPool tp, UbikServerSocketFactory socketFactory) throws IOException {
        this(bindAddr, port, new SocketConnectionFactory(), tp, socketFactory);
    }

    protected SocketServer(int port, SocketConnectionFactory fac, ThreadPool tp, UbikServerSocketFactory socketFactory) throws IOException {
        this._server = socketFactory.createServerSocket(port);
        this._fac = fac;
        this._tp = tp;
    }

    protected SocketServer(String bindAddr, int port, SocketConnectionFactory fac, ThreadPool tp, UbikServerSocketFactory socketFactory) throws IOException {
        this._server = socketFactory.createServerSocket(port, bindAddr);
        this._fac = fac;
        this._tp = tp;
    }

    protected SocketServer(ThreadPool tp, ServerSocket server) throws IOException {
        this(new SocketConnectionFactory(), tp, server);
    }

    protected SocketServer(SocketConnectionFactory fac, ThreadPool tp, ServerSocket server) throws IOException {
        this._server = server;
        this._fac = fac;
        this._tp = tp;
    }

    public String getAddress() {
        if (this._address == null) {
            this._address = this._server.getInetAddress().getHostAddress();
            if (this._address.equals("0.0.0.0")) {
                try {
                    this._address = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(e.getClass().getName() + " caught - msg " + e.getMessage());
                }
            }
        }
        return this._address;
    }

    public void enableStats() {
        this._tp.enabledStats();
    }

    public void disableStats() {
        this._tp.disableStats();
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public Statistic getRequestsPerSecondStat() {
        return this._tp.getRpsStat();
    }

    public Statistic getRequestDurationStat() {
        return this._tp.getDurationStat();
    }

    public int getThreadCount() {
        return this._tp.getThreadCount();
    }

    public void close() {
        try {
            this._tp.shutdown();
            this._server.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this._tp.fill(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        block9: while (true) {
            try {
                while (true) {
                    Socket client;
                    block13: {
                        client = null;
                        try {
                            if (!this._started) {
                                try {
                                    this._server.setSoTimeout(1);
                                    client = this._server.accept();
                                }
                                catch (SocketTimeoutException e) {
                                    // empty catch block
                                }
                                this._started = true;
                                this._server.setSoTimeout(0);
                                this.notifyStarted();
                                if (client == null) {
                                    continue;
                                }
                                break block13;
                            }
                            client = this._server.accept();
                        }
                        catch (SocketTimeoutException ste) {
                            continue;
                        }
                        catch (SocketException e) {
                            if (this._started) break block9;
                            this._startExc = e;
                            this._started = true;
                            this.notifyStarted();
                            break block9;
                        }
                    }
                    Connection conn = this._fac.newConnection(client);
                    Request req = new Request(conn, new TCPAddress(this.getAddress(), this.getPort()));
                    ((PooledThread)this._tp.acquire()).exec(req);
                }
            }
            catch (Throwable t) {
                if (!this.handleError(t)) continue;
                this.close();
            }
            break;
        }
    }

    public synchronized void waitStarted() throws InterruptedException, SocketException {
        while (!this._started) {
            this.wait();
        }
        if (this._startExc != null) {
            throw this._startExc;
        }
    }

    protected synchronized void notifyStarted() {
        this.notifyAll();
    }

    protected boolean handleError(Throwable t) {
        t.printStackTrace();
        return true;
    }
}

