/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.sapia.ubik.net.ServerAddress;

public class TCPAddress
implements Externalizable,
ServerAddress {
    static final long serialVersionUID = 1L;
    public static final String TRANSPORT_TYPE = "tcp/socket";
    private String _host;
    private int _port;
    private int _hashCode;
    protected String _transportType = "tcp/socket";

    public TCPAddress() {
    }

    public TCPAddress(String host, int port) {
        this._host = host;
        this._port = port;
        this._hashCode = (host + port).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        try {
            TCPAddress other = (TCPAddress)obj;
            return other._port == this._port && other._host.equals(this._host);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._host = in.readUTF();
        this._port = in.readInt();
        this._hashCode = in.readInt();
        this._transportType = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._host);
        out.writeInt(this._port);
        out.writeInt(this._hashCode);
        out.writeUTF(this._transportType);
    }

    @Override
    public String getTransportType() {
        return this._transportType;
    }

    public String toString() {
        return "[ host=" + this._host + ", port=" + this._port + ", type=" + this._transportType + " ]";
    }
}

