/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;

public class TcpPortSelector {
    private static final int MIN_PORT = 1025;
    private static final int MAX_PORT = 65535;
    private static final int MAX_ATTEMPS = 100;

    public int select(InetAddress addr) throws IOException {
        return this.select(addr.getHostAddress());
    }

    public int select(String host) throws IOException {
        int port = this.doSelect(host);
        try {
            Thread.sleep(new Random().nextInt(100));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread interrupted");
        }
        if (this.isTaken(host, port)) {
            port = this.doSelect(host);
        }
        if (this.isTaken(host, port)) {
            throw new IOException("No port could be randomly acquired on : " + host);
        }
        return port;
    }

    private int doSelect(String host) throws IOException {
        Random rand = new Random();
        for (int attempts = 0; attempts < 100; ++attempts) {
            int current = 1025 + rand.nextInt(64510);
            try {
                Socket sock = new Socket(host, current);
                try {
                    sock.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                continue;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown host");
            }
            catch (ConnectException e) {
                return current;
            }
            catch (IOException e) {
                throw e;
            }
        }
        throw new IOException("No port could be randomly acquired on : " + host);
    }

    private boolean isTaken(String host, int port) {
        try {
            Socket sock = new Socket(host, port);
            try {
                sock.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        catch (ConnectException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

