/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import java.util.ArrayList;
import java.util.List;
import org.sapia.ubik.net.Pool;
import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.Timer;
import org.sapia.ubik.rmi.server.perf.HitStatFactory;
import org.sapia.ubik.rmi.server.perf.HitsPerSecStatistic;
import org.sapia.ubik.rmi.server.perf.Statistic;

public abstract class ThreadPool
extends Pool {
    private String _name;
    private boolean _daemon;
    private boolean _shuttingDown;
    private List _busy = new ArrayList();
    private HitsPerSecStatistic _tps = HitStatFactory.createHitsPerSec("TPC", 0L, null);
    private Statistic _duration = new Statistic("Duration");

    protected ThreadPool(String name, boolean daemon, int maxSize) {
        super(maxSize);
        this._name = name;
        this._daemon = daemon;
    }

    protected ThreadPool(String name, boolean daemon) {
        this._name = name;
        this._daemon = daemon;
    }

    @Override
    protected Object onAcquire(Object o) throws Exception, IllegalStateException {
        if (this._shuttingDown) {
            throw new IllegalStateException("Could not acquire thread; pool is shutting down");
        }
        ((PooledThread)o).acquire();
        this._busy.add(o);
        return o;
    }

    @Override
    protected synchronized void onRelease(Object o) {
        ((PooledThread)o).release();
        this._busy.remove(o);
        this.notifyAll();
    }

    public Statistic getRpsStat() {
        return this._tps;
    }

    public Statistic getDurationStat() {
        return this._duration;
    }

    public void enabledStats() {
        this._tps.setEnabled(true);
        this._duration.setEnabled(true);
    }

    public void disableStats() {
        this._tps.setEnabled(false);
        this._duration.setEnabled(false);
    }

    public synchronized void shutdown() {
        this.shutdown(0L);
    }

    public int getThreadCount() {
        return this._busy.size();
    }

    public synchronized void shutdown(long timeout) {
        int i;
        this._shuttingDown = true;
        for (i = 0; i < this._objects.size(); ++i) {
            ((PooledThread)this._objects.get(i)).shutdown();
        }
        if (this._busy.size() > 0) {
            for (i = 0; i < this._busy.size(); ++i) {
                ((PooledThread)this._busy.get(i)).shutdown();
            }
            Timer timer = new Timer(timeout);
            while (this._busy.size() != 0) {
                try {
                    this.wait(timeout);
                    if (!timer.isOver()) continue;
                    break;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @Override
    protected final Object doNewObject() throws Exception {
        PooledThread th = this.newThread();
        th.setTpsStat(this._tps);
        th.setDurationStat(this._duration);
        th.setOwner(this);
        th.setName("[" + this._name + " - " + super.getCreatedCount() + "]");
        th.setDaemon(this._daemon);
        th.start();
        return th;
    }

    protected abstract PooledThread newThread() throws Exception;
}

