/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net;

import org.sapia.ubik.net.QueryString;
import org.sapia.ubik.net.QueryStringParser;
import org.sapia.ubik.net.UriSyntaxException;

public class Uri {
    public static final int UNDEFINED_PORT = -1;
    public static final String UNDEFINED_HOST = "";
    private static final QueryStringParser PARSER = new QueryStringParser();
    private static final String PROTO = "://";
    private static final char COLON = ':';
    private static final char SLASH = '/';
    private String _scheme;
    private String _host;
    private QueryString _query;
    private int _port = -1;

    private Uri() {
    }

    public Uri(String scheme, String host, int port, String path) {
        this._scheme = scheme;
        this._host = host;
        this._port = port;
        this._query = new QueryString(UNDEFINED_HOST);
    }

    public String getPath() {
        return this._query.getPath();
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public QueryString getQueryString() {
        return this._query;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this._scheme);
        if (this._host != null && !this._host.equals(UNDEFINED_HOST)) {
            buf.append(PROTO).append(this._host);
            if (this._port != -1) {
                buf.append(':').append(this._port);
            }
        } else {
            buf.append(':');
        }
        buf.append(this._query.toString());
        return buf.toString();
    }

    public static Uri parse(String uriStr) throws UriSyntaxException {
        Uri uri = new Uri();
        Uri.parseUrl(uri, uriStr);
        return uri;
    }

    void setQueryString(QueryString str) {
        this._query = str;
    }

    private static void parseUrl(Uri url, String str) throws UriSyntaxException {
        int idx = str.indexOf(PROTO);
        if (idx < 0) {
            url.setHost(UNDEFINED_HOST);
            idx = str.indexOf(58);
            if (idx < 0) {
                url.setScheme(str);
                url.setQueryString(new QueryString(UNDEFINED_HOST));
            } else {
                url.setScheme(str.substring(0, idx));
                url.setQueryString(PARSER.parseQueryString(str.substring(idx + 1)));
            }
        } else {
            String proto = str.substring(0, idx);
            if (proto.length() == 0) {
                throw new UriSyntaxException("Empty protocol in URI: " + str);
            }
            url.setScheme(proto);
            Uri.parseHost(url, str.substring(idx + PROTO.length()));
        }
    }

    private static void parseHost(Uri url, String str) throws UriSyntaxException {
        int idx = str.indexOf(58);
        if (idx >= 0) {
            String host = str.substring(0, idx);
            if (host.length() == 0) {
                url.setHost(UNDEFINED_HOST);
            } else {
                url.setHost(host);
                Uri.parsePort(url, str.substring(idx + 1));
            }
        } else {
            idx = str.indexOf(47);
            String host = idx < 0 ? str : str.substring(0, idx);
            if (host.length() == 0) {
                url.setHost(UNDEFINED_HOST);
            } else {
                url.setHost(host);
            }
            if (idx > 0) {
                String qString = str.substring(idx);
                url.setQueryString(PARSER.parseQueryString(qString));
            } else {
                url.setQueryString(new QueryString(UNDEFINED_HOST));
            }
        }
    }

    private static void parsePort(Uri url, String str) throws UriSyntaxException {
        int idx = str.indexOf(47);
        String port = idx < 0 ? str.substring(0) : str.substring(0, idx);
        if (port.length() == 0) {
            throw new UriSyntaxException("Port expected but not specified in URI: " + str);
        }
        try {
            url.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            throw new UriSyntaxException("Port is not a valid number: " + str);
        }
        if (idx > 0) {
            String qString = str.substring(idx);
            url.setQueryString(PARSER.parseQueryString(qString));
        } else {
            url.setQueryString(new QueryString(UNDEFINED_HOST));
        }
    }
}

