/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.mplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sapia.ubik.net.mplex.MultiplexSocket;
import org.sapia.ubik.net.mplex.MultiplexSocketConnector;
import org.sapia.ubik.net.mplex.PositiveStreamSelector;
import org.sapia.ubik.net.mplex.SocketConnectorImpl;
import org.sapia.ubik.net.mplex.SocketQueue;
import org.sapia.ubik.net.mplex.StreamSelector;
import org.sapia.ubik.rmi.server.Log;

public class MultiplexServerSocket
extends ServerSocket
implements Runnable {
    public static final short DEFAULT_READ_AHEAD_BUFFER_SIZE = 64;
    public static final short DEFAULT_ACCEPTOR_DAEMON_THREAD = 3;
    public static final short DEFAULT_SELECTOR_DAEMON_THREAD = 3;
    private List<MultiplexSocketConnector> _theConnectors = new ArrayList<MultiplexSocketConnector>();
    private SocketConnectorImpl _theDefaultConnector;
    private List<Thread> _theAcceptorDaemons = new ArrayList<Thread>();
    private List<Thread> _theSelectorDaemons = new ArrayList<Thread>();
    private SocketQueue _theAcceptedQueue = new SocketQueue();
    private int _theAcceptorDaemonThread = 3;
    private int _theSelectorDaemonThread = 3;
    private int _theReadAheadBufferSize = 64;

    public MultiplexServerSocket() throws IOException {
    }

    public MultiplexServerSocket(int port) throws IOException {
        super(port, 50);
    }

    public MultiplexServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public MultiplexServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public int getReadAheadBufferSize() {
        return this._theReadAheadBufferSize;
    }

    public void setReadAheadBufferSize(int aSize) {
        if (aSize <= 0) {
            throw new IllegalArgumentException("The size is less than zero");
        }
        if (this._theAcceptorDaemons.size() > 0) {
            throw new IllegalStateException("Cannot change the read ahead buffer size on a running server socket");
        }
        this._theReadAheadBufferSize = aSize;
    }

    public int getAcceptorDaemonThread() {
        return this._theAcceptorDaemonThread;
    }

    public int getSelectorDaemonThread() {
        return this._theSelectorDaemonThread;
    }

    public void setAcceptorDaemonThread(int maxThread) {
        if (maxThread <= 0) {
            throw new IllegalArgumentException("The size is less than zero");
        }
        if (this._theAcceptorDaemons.size() > 0) {
            throw new IllegalStateException("Cannot change the number of acceptor daemons on a running server socket");
        }
        this._theAcceptorDaemonThread = maxThread;
    }

    public void setSelectorDaemonThread(int maxThread) {
        if (maxThread <= 0) {
            throw new IllegalArgumentException("The size is less than zero");
        }
        if (this._theSelectorDaemons.size() > 0) {
            throw new IllegalStateException("Cannot change the number of selector daemons on a running server socket");
        }
        this._theSelectorDaemonThread = maxThread;
    }

    public synchronized MultiplexSocketConnector createSocketConnector(StreamSelector aSelector) {
        if (aSelector == null) {
            throw new IllegalArgumentException("The selector passed in is null");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Could not create a socket connector, the server socket is closed");
        }
        SocketConnectorImpl aConnector = new SocketConnectorImpl(this, aSelector, new SocketQueue());
        this._theConnectors.add(aConnector);
        return aConnector;
    }

    private synchronized void initializeDefaultConnector() {
        if (this._theDefaultConnector == null) {
            Thread aDaemon;
            int i;
            this._theDefaultConnector = new SocketConnectorImpl(this, new PositiveStreamSelector(), new SocketQueue());
            for (i = 1; i <= this._theAcceptorDaemonThread; ++i) {
                aDaemon = new Thread((Runnable)new SelectorTask(), "MultiplexServerSocket-Selector" + i);
                aDaemon.setDaemon(true);
                this._theSelectorDaemons.add(aDaemon);
                aDaemon.start();
            }
            for (i = 1; i <= this._theAcceptorDaemonThread; ++i) {
                aDaemon = new Thread((Runnable)this, "MultiplexServerSocket-Acceptor" + i);
                aDaemon.setDaemon(true);
                this._theAcceptorDaemons.add(aDaemon);
                aDaemon.start();
            }
        }
    }

    public synchronized void removeSocketConnector(MultiplexSocketConnector aConnector) {
        if (aConnector == null) {
            throw new IllegalArgumentException("The connector passed in is null");
        }
        this._theConnectors.remove(aConnector);
    }

    private byte[] extractHeader(MultiplexSocket aSocket, int aMaxLength) throws IOException {
        byte[] header;
        byte[] preview = new byte[aMaxLength];
        int length = aSocket.getPushbackInputStream().read(preview, 0, preview.length);
        aSocket.getPushbackInputStream().unread(preview, 0, length);
        if (length < preview.length) {
            header = new byte[length];
            System.arraycopy(preview, 0, header, 0, length);
        } else {
            header = preview;
        }
        return header;
    }

    @Override
    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        if (this._theDefaultConnector == null) {
            this.initializeDefaultConnector();
        }
        return this._theDefaultConnector.getQueue().getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this._theDefaultConnector != null) {
                this._theDefaultConnector.close();
            }
            if (this._theConnectors != null) {
                for (MultiplexSocketConnector connector : new ArrayList<MultiplexSocketConnector>(this._theConnectors)) {
                    connector.close();
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append("MultiplexServerSocket[").append(super.toString()).append("]");
        return aBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Log.warning(this.getClass(), (Object)(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * REPORT * Starting this acceptor thread"));
            while (!this.isClosed() && !Thread.interrupted()) {
                try {
                    MultiplexSocket aClient = new MultiplexSocket(null, this._theReadAheadBufferSize);
                    this.implAccept(aClient);
                    this._theAcceptedQueue.add(aClient);
                }
                catch (IOException ioe) {
                    this._theDefaultConnector.getQueue().setException(ioe);
                }
                catch (RuntimeException re) {
                    this._theDefaultConnector.getQueue().setException(new IOException(re.getLocalizedMessage()));
                }
            }
        }
        catch (Exception e) {
            Log.error(this.getClass(), (Object)(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * ERROR * An unhandled exception occured in this acceptor thread... EXITING LOOP"), (Throwable)e);
        }
        finally {
            Log.warning(this.getClass(), (Object)(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * REPORT * Stopping this acceptor thread"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketConnectorImpl selectConnector(MultiplexSocket aClient) throws IOException {
        SocketConnectorImpl aConnector = null;
        if (this._theConnectors.size() > 0) {
            byte[] header = this.extractHeader(aClient, this._theReadAheadBufferSize);
            MultiplexServerSocket multiplexServerSocket = this;
            synchronized (multiplexServerSocket) {
                for (SocketConnectorImpl socketConnectorImpl : this._theConnectors) {
                    if (!socketConnectorImpl.getSelector().selectStream(header)) continue;
                    aConnector = socketConnectorImpl;
                    break;
                }
            }
        }
        return aConnector;
    }

    public class SelectorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Log.warning(this.getClass(), (Object)(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * REPORT * Starting this selector thread"));
                while (!MultiplexServerSocket.this.isClosed() && !Thread.interrupted()) {
                    try {
                        MultiplexSocket aSocket = (MultiplexSocket)MultiplexServerSocket.this._theAcceptedQueue.getSocket();
                        SocketConnectorImpl aConnector = MultiplexServerSocket.this.selectConnector(aSocket);
                        if (aConnector == null) {
                            MultiplexServerSocket.this._theDefaultConnector.getQueue().add(aSocket);
                            continue;
                        }
                        aConnector.getQueue().add(aSocket);
                    }
                    catch (IOException ioe) {
                        MultiplexServerSocket.this._theDefaultConnector.getQueue().setException(ioe);
                    }
                    catch (RuntimeException re) {
                        MultiplexServerSocket.this._theDefaultConnector.getQueue().setException(new IOException(re.getLocalizedMessage()));
                    }
                }
            }
            catch (Exception e) {
                Log.error(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * ERROR * An unhandled exception occured in this selector thread... EXITING LOOP", (Object)e);
            }
            finally {
                Log.warning(this.getClass(), (Object)(new Date() + " [" + Thread.currentThread().getName() + "] MultiplexServerSocket * REPORT * Stopping this selector thread"));
            }
        }
    }
}

