/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.mplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.sapia.ubik.net.mplex.MultiplexServerSocket;
import org.sapia.ubik.net.mplex.MultiplexSocketConnector;
import org.sapia.ubik.net.mplex.SocketQueue;
import org.sapia.ubik.net.mplex.StreamSelector;

public class SocketConnectorImpl
implements MultiplexSocketConnector {
    private MultiplexServerSocket _theServerSocket;
    private StreamSelector _theSelector;
    private SocketQueue _theQueue;
    private boolean _isClosed;

    public SocketConnectorImpl(MultiplexServerSocket aServerSocket, StreamSelector aSelector, SocketQueue aQueue) {
        this._theServerSocket = aServerSocket;
        this._theSelector = aSelector;
        this._theQueue = aQueue;
        this._isClosed = false;
    }

    public StreamSelector getSelector() {
        return this._theSelector;
    }

    public SocketQueue getQueue() {
        return this._theQueue;
    }

    @Override
    public int getLocalPort() {
        return this._theServerSocket.getLocalPort();
    }

    @Override
    public InetAddress getInetAddress() {
        return this._theServerSocket.getInetAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this._theServerSocket.getLocalSocketAddress();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this._theServerSocket.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this._theServerSocket.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this._theServerSocket.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return this._theServerSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this._isClosed || this._theServerSocket.isClosed();
    }

    @Override
    public Socket accept() throws IOException {
        return this._theQueue.getSocket();
    }

    @Override
    public void close() throws IOException {
        this._theServerSocket.removeSocketConnector(this);
        this._theQueue.close();
        this._isClosed = true;
    }
}

