/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.mplex;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;

public class SocketQueue {
    private LinkedList _theSockets = new LinkedList();
    private boolean _isClosed = false;
    private IOException _theLastException;

    public synchronized void add(Socket aSocket) throws SocketException {
        if (this._isClosed) {
            throw new SocketException("Could not add socket - the socket queue is closed");
        }
        this._theLastException = null;
        this._theSockets.addLast(aSocket);
        this.notify();
    }

    public synchronized Socket getSocket() throws IOException {
        if (this._isClosed) {
            throw new SocketException("No socket available - the socket queue is closed");
        }
        if (this._theSockets.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this._isClosed) {
            throw new SocketException("No socket available - the socket queue is closed");
        }
        if (this._theLastException != null) {
            IOException ioe = this._theLastException;
            this._theLastException = null;
            throw ioe;
        }
        if (this._theSockets.isEmpty()) {
            return this.getSocket();
        }
        return (Socket)this._theSockets.removeFirst();
    }

    public synchronized void close() {
        this._isClosed = true;
        for (Socket socket : this._theSockets) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        this._theSockets.clear();
        this.notifyAll();
    }

    public synchronized void setException(IOException anException) {
        this._theLastException = anException;
        this.notify();
    }

    public IOException getException() {
        return this._theLastException;
    }

    public int size() {
        return this._theSockets.size();
    }
}

