/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.rmi.RemoteException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.udp.ObjectStreamFactory;
import org.sapia.ubik.net.udp.UDPServerAddress;
import org.sapia.ubik.net.udp.Util;

public class UDPConnection
implements Connection {
    protected int _bufsz;
    private UDPServerAddress _addr;
    private DatagramPacket _pack;
    private DatagramSocket _sock;
    private int _timeout;

    public UDPConnection(UDPServerAddress addr, int bufsz, int timeout) {
        this._addr = addr;
        this._bufsz = bufsz;
        this._timeout = timeout;
    }

    public UDPConnection(DatagramSocket localServer, DatagramPacket pack, int bufsz, int timeout) {
        this._addr = new UDPServerAddress(pack.getAddress(), pack.getPort());
        this._pack = pack;
        this._sock = localServer;
        this._bufsz = bufsz;
        this._timeout = timeout;
    }

    @Override
    public void close() {
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._addr;
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        DatagramPacket pack;
        if (this._sock == null) {
            this._sock = new DatagramSocket(this._addr.getPort());
            this._sock.setSoTimeout(this._timeout);
        }
        if (this._pack == null) {
            pack = new DatagramPacket(new byte[this._bufsz], this._bufsz);
        } else {
            pack = this._pack;
            this._pack = null;
        }
        this._sock.receive(pack);
        return Util.fromDatagram(pack);
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        byte[] bytes = Util.toBytes(o, this._bufsz, this.getFactory());
        this.send(bytes);
    }

    protected void send(byte[] bytes) throws IOException, RemoteException {
        if (this._sock == null) {
            this._sock = new DatagramSocket();
            this._sock.setSoTimeout(this._timeout);
        }
        DatagramPacket pack = new DatagramPacket(bytes, 0, bytes.length, this._addr.getInetAddress(), this._addr.getPort());
        this._sock.send(pack);
    }

    protected ObjectStreamFactory getFactory() {
        return ObjectStreamFactory.DEFAULT_FACTORY;
    }
}

