/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ConnectionFactory;
import org.sapia.ubik.net.udp.UDPConnection;
import org.sapia.ubik.net.udp.UDPServerAddress;

public class UDPConnectionFactory
implements ConnectionFactory {
    private int _bufSize;
    private int _timeout;

    public UDPConnectionFactory(int bufSize, int timeout) {
        this._bufSize = bufSize;
        this._timeout = timeout;
    }

    @Override
    public Connection newConnection(String host, int port) throws IOException {
        return new UDPConnection(new UDPServerAddress(InetAddress.getByName(host), port), this._bufSize, this._timeout);
    }

    public UDPConnection newConnection(InetAddress addr, int port) throws IOException {
        return new UDPConnection(new UDPServerAddress(addr, port), this._bufSize, this._timeout);
    }

    public UDPConnection newConnection(DatagramSocket localSocket, DatagramPacket pack) throws IOException {
        return new UDPConnection(localSocket, pack, this._bufSize, this._timeout);
    }
}

