/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.net.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.udp.UDPConnection;
import org.sapia.ubik.net.udp.UDPConnectionFactory;
import org.sapia.ubik.net.udp.UDPServerAddress;
import org.sapia.ubik.net.udp.Util;

public class UDPServer
implements Runnable {
    protected static final int DEFAULT_BUFSZ = 1000;
    protected static final int DEFAULT_TIMEOUT = 30000;
    protected DatagramSocket _server;
    private int _bufsize = 1000;
    private UDPConnectionFactory _fac;

    public UDPServer(DatagramSocket server) {
        this._server = server;
        this._fac = new UDPConnectionFactory(1000, 30000);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    DatagramPacket pack = new DatagramPacket(new byte[this._bufsize], this._bufsize);
                    UDPConnection conn = null;
                    this._server.receive(pack);
                    conn = this._fac.newConnection(this._server, pack);
                    this.handleRequest(new Request(conn, new UDPServerAddress(this._server.getLocalAddress(), this._server.getLocalPort())), Util.fromDatagram(pack));
                }
            }
            catch (Throwable t) {
                if (!this.handleError(t)) continue;
                this.close();
                return;
            }
            break;
        }
    }

    protected void handleRequest(Request req, Object data) {
        try {
            System.out.println("received " + data);
            req.getConnection().send("BAR");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void close() {
        if (this._server != null) {
            this._server.close();
        }
    }

    protected boolean handleError(Throwable t) {
        t.printStackTrace();
        return true;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Starting server...");
            UDPServer server = new UDPServer(new DatagramSocket(6666));
            Thread t = new Thread(server);
            t.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

