/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sapia.ubik.rmi.server.Log;

public class PropUtil {
    private List _props = new ArrayList();

    public PropUtil addProperties(Properties props) {
        this._props.add(props);
        return this;
    }

    public int getIntProperty(String key) throws NumberFormatException, IllegalArgumentException {
        String val = this.lookup(key, true);
        return Integer.parseInt(val);
    }

    public int getIntProperty(String key, int defaultValue) throws NumberFormatException {
        String val = this.lookup(key, false);
        if (val == null) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    public long getLongProperty(String key) throws NumberFormatException, IllegalArgumentException {
        String val = this.lookup(key, true);
        return Long.parseLong(val);
    }

    public long getLongProperty(String key, long defaultValue) throws NumberFormatException {
        String val = this.lookup(key, false);
        if (val == null) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    public float getFloatProperty(String key) throws NumberFormatException, IllegalArgumentException {
        String val = this.lookup(key, true);
        return Long.parseLong(val);
    }

    public float getFloat(String key, float defaultValue) throws NumberFormatException {
        String val = this.lookup(key, false);
        if (val == null) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    public boolean getBooleanProperty(String key) {
        String val = this.lookup(key, false);
        if (val == null) {
            return false;
        }
        return (val = val.toLowerCase()).equals("true") || val.equals("yes") || val.equals("yes");
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String val = this.lookup(key, false);
        if (val == null) {
            return defaultValue;
        }
        return (val = val.toLowerCase()).equals("true") || val.equals("yes") || val.equals("yes");
    }

    public String getProperty(String key) {
        return this.lookup(key, false);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.lookup(key, false);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    private String lookup(String key, boolean throwExcIfNotFound) {
        for (int i = 0; i < this._props.size(); ++i) {
            Properties current = (Properties)this._props.get(i);
            String val = current.getProperty(key);
            if (val == null) continue;
            Log.info("**** PROPERTY ****", (Object)(key + " = " + val));
            return val;
        }
        if (throwExcIfNotFound) {
            throw new IllegalArgumentException("No value found for property: " + key);
        }
        return null;
    }
}

