/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RMIClassLoader;

public class Utils {
    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object o = ois.readObject();
        return o;
    }

    public static Object deserialize(byte[] bytes, ClassLoader loader) throws IOException, ClassNotFoundException {
        ObjectInputStreamEx ois = new ObjectInputStreamEx(new ByteArrayInputStream(bytes), loader);
        Object o = ois.readObject();
        return o;
    }

    public static Object deserialize(byte[] bytes, ClassLoader loader, String codebase) throws IOException, ClassNotFoundException {
        RMIClassLoader.getClassLoader(codebase);
        ObjectInputStreamEx ois = new ObjectInputStreamEx(new ByteArrayInputStream(bytes), loader);
        Object o = ois.readObject();
        return o;
    }

    public static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream ous = new ObjectOutputStream(bos);
        ous.writeObject(o);
        ous.flush();
        ous.close();
        return bos.toByteArray();
    }

    static final class ObjectInputStreamEx
    extends ObjectInputStream {
        private ClassLoader _loader;

        ObjectInputStreamEx(InputStream is, ClassLoader loader) throws IOException {
            super(is);
            this._loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this._loader != null) {
                return this._loader.loadClass(desc.getName());
            }
            return super.resolveClass(desc);
        }
    }
}

