/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import org.sapia.ubik.rmi.examples.Bar;
import org.sapia.ubik.rmi.examples.Foo;
import org.sapia.ubik.rmi.naming.remote.RemoteInitialContextFactory;
import org.sapia.ubik.rmi.server.Log;

public class Bench {
    public static void main(String[] args) {
        Log.setWarning();
        try {
            System.out.println();
            Foo f = Bench.getNioUbikFoo();
            System.out.println("==== Producing numbers for Ubik NIO RMI... ====");
            System.out.println();
            Bench.doGetBar(f);
            System.out.println();
            Bench.doGetMsg(f);
            System.out.println("Press CTRL-C to exit");
            while (true) {
                Thread.sleep(100000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    private static Foo getJdkFoo() throws Throwable {
        return (Foo)Naming.lookup("rmi://localhost:1098/Foo");
    }

    private static Foo getStandardUbikFoo() throws Throwable {
        Properties props = new Properties();
        props.setProperty("java.naming.provider.url", "ubik://localhost:1099/");
        props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        InitialContext ctx = new InitialContext(props);
        return (Foo)ctx.lookup("Foo");
    }

    private static Foo getNioUbikFoo() throws Throwable {
        Properties props = new Properties();
        props.setProperty("java.naming.provider.url", "ubik://localhost:1099/");
        props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        InitialContext ctx = new InitialContext(props);
        return (Foo)ctx.lookup("NioFoo");
    }

    private static void doGetBar(Foo f) throws RemoteException {
        System.out.println("Calling getBar() on Foo (returns a remote Object)");
        for (int i = 0; i < 4; ++i) {
            long start = 0L;
            long total = 0L;
            long maxTime = 1000L;
            int callCount = 0;
            System.out.println();
            System.out.println(">>run " + (i + 1));
            do {
                start = System.currentTimeMillis();
                f.getBar();
                ++callCount;
            } while ((total += System.currentTimeMillis() - start) < maxTime);
            System.out.println("" + callCount + "/" + total + " (number of calls/number of millis)");
        }
    }

    private static void doGetMsg(Foo f) throws RemoteException {
        System.out.println("Calling getMsg() on Bar (getMsg() returns a string)");
        Bar b = f.getBar();
        for (int i = 0; i < 4; ++i) {
            long start = 0L;
            long total = 0L;
            long maxTime = 1000L;
            int callCount = 0;
            System.out.println();
            System.out.println(">>run " + (i + 1));
            do {
                start = System.currentTimeMillis();
                b.getMsg();
                ++callCount;
            } while ((total += System.currentTimeMillis() - start) < maxTime);
            System.out.println("" + callCount + "/" + total + " (number of calls/number of millis)");
        }
    }
}

