/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import org.sapia.ubik.ioc.guice.NamingService;
import org.sapia.ubik.ioc.guice.NamingServiceImpl;
import org.sapia.ubik.ioc.guice.RemoteServiceImporter;
import org.sapia.ubik.rmi.examples.time.TimeServiceIF;
import org.sapia.ubik.util.Localhost;

public class GuiceTimeClient {
    public static void main(String[] args) throws IOException {
        final NamingServiceImpl naming = new NamingServiceImpl("default").setJndiHost(Localhost.getAnyLocalAddress().getHostAddress()).setJndiPort(1099);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(NamingService.class).toInstance((Object)naming);
                this.bind(TimeServiceIF.class).toProvider(new RemoteServiceImporter<TimeServiceIF>(TimeServiceIF.class, "services/time"));
            }
        }});
        TimeServiceIF service = (TimeServiceIF)injector.getInstance(TimeServiceIF.class);
        System.out.println("Got time: " + service.getTime());
    }
}

