/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.sapia.ubik.ioc.guice.NamingService;
import org.sapia.ubik.ioc.guice.NamingServiceImpl;
import org.sapia.ubik.ioc.guice.RemoteServiceExporter;
import org.sapia.ubik.rmi.examples.time.TimeServiceIF;
import org.sapia.ubik.rmi.examples.time.TimeServiceImpl;
import org.sapia.ubik.util.Localhost;

public class GuiceTimeServer {
    public static void main(String[] args) throws Exception {
        final NamingServiceImpl naming = new NamingServiceImpl("default").setJndiHost(Localhost.getAnyLocalAddress().getHostAddress()).setJndiPort(1099);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(NamingService.class).toInstance((Object)naming);
                this.bind(TimeServiceIF.class).toProvider(new RemoteServiceExporter<TimeServiceImpl>(new TimeServiceImpl(), "services/time"));
            }
        }});
        TimeServiceIF server = (TimeServiceIF)injector.getInstance(TimeServiceIF.class);
        System.out.println("Bound time server");
        while (true) {
            Thread.sleep(10000L);
        }
    }
}

