/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.http;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.servlet.ServletHandler;
import org.sapia.ubik.rmi.examples.Foo;
import org.sapia.ubik.rmi.examples.UbikFoo;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.transport.TransportManager;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletTransportProvider;

public class HttpFooServlet
extends HttpServlet {
    static final String SERVLET_URL = "http://localhost:8080/ubik";
    private Foo _foo;
    private ServletTransportProvider _provider;

    public void init(ServletConfig conf) throws ServletException {
        this._provider = new ServletTransportProvider();
        TransportManager.registerProvider(this._provider);
        Properties props = new Properties();
        props.setProperty("ubik.rmi.transport.servlet.url", SERVLET_URL);
        props.setProperty("ubik.rmi.transport.type", "http/servlet");
        try {
            this._foo = new UbikFoo();
            Hub.exportObject((Object)this._foo, props);
        }
        catch (RemoteException e) {
            throw new ServletException("Could not export Foo", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this._provider.handleRequest(req, res);
    }

    public void destroy() {
        try {
            Hub.shutdown(30000L);
        }
        catch (Exception e) {
            this.getServletContext().log("Exception caught performing Hub shutdown", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            HttpServer server = new HttpServer();
            server.addListener(":8080");
            HttpContext context = server.getContext("/");
            ServletHandler handler = new ServletHandler();
            handler.addServlet("Ubik", "/ubik/*", "org.sapia.ubik.rmi.examples.http.HttpFooServlet");
            context.addHandler((HttpHandler)handler);
            server.start();
            while (true) {
                Thread.sleep(100000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

