/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.jndi;

import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import org.sapia.ubik.rmi.examples.Foo;
import org.sapia.ubik.rmi.examples.ReliableFoo;
import org.sapia.ubik.rmi.naming.remote.RemoteInitialContextFactory;

public class JndiBrowsingEg {
    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            System.setProperty("ubik.rmi.marshalling", "true");
            props.setProperty("java.naming.provider.url", "ubik://localhost:1099");
            props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
            InitialContext ctx = new InitialContext(props);
            ReliableFoo foo = new ReliableFoo();
            System.out.println("Creating subcontext...");
            ctx.createSubcontext("/path1");
            Context child = ctx.createSubcontext("/path1/path2");
            System.out.println("Binding Foo to subcontext...");
            child.bind("foo", (Object)foo);
            child.bind("foo", (Object)foo);
            System.out.println("Looking up...");
            Foo server = (Foo)ctx.lookup("/path1/path2/foo");
            System.out.println("Looked up; now listing bindings...");
            NamingEnumeration<Binding> en = ctx.listBindings("/path1");
            while (en.hasMore()) {
                Binding b = en.next();
                System.out.println("Got child context from enumeration: " + b.getName());
                child = (Context)b.getObject();
                child.lookup("foo");
                System.out.println("Looked up Foo from child context");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

