/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.replication;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Set;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.examples.Foo;
import org.sapia.ubik.rmi.replication.ReplicatedCommand;
import org.sapia.ubik.rmi.replication.ReplicatedInvoker;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;

public class ReplicatedInvokerImpl
implements ReplicatedInvoker {
    private transient Foo _server;
    private transient Set _siblings;

    @Override
    public Object invoke(String methodName, Class[] sig, Object[] params) throws Throwable {
        System.out.println("Invoking: " + methodName);
        Method m = this._server.getClass().getMethod(methodName, sig);
        return m.invoke((Object)this._server, params);
    }

    @Override
    public Set getSiblings() {
        return this._siblings;
    }

    void setTargetInstance(Foo server) {
        this._server = server;
    }

    void setSiblings(Set siblings) {
        this._siblings = siblings;
    }

    public void dispatch(ReplicatedCommand cmd, ServerAddress addr) throws RemoteException {
        Object toReturn;
        System.out.println("Dispatching replicated command");
        Connections conns = TransportManager.getConnectionsFor(addr);
        RmiConnection conn = conns.acquire();
        try {
            conn.send(cmd);
            toReturn = conn.receive();
        }
        catch (RemoteException e) {
            conn.close();
            throw e;
        }
        catch (IOException e) {
            RemoteException re = new RemoteException("Could not send replicated command", e);
            conn.close();
            throw re;
        }
        catch (ClassNotFoundException e) {
            RemoteException re = new RemoteException("Could not receive response for replicated command", e);
            conn.close();
            throw re;
        }
        conns.release(conn);
        if (toReturn instanceof Throwable) {
            if (toReturn instanceof RemoteException) {
                throw (RemoteException)toReturn;
            }
            throw new RemoteException("Exception caught dispatching command", (Throwable)toReturn);
        }
    }
}

