/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.time;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.sapia.ubik.rmi.examples.time.StatelessTimeServiceImpl;
import org.sapia.ubik.rmi.examples.time.TimeServiceIF;
import org.sapia.ubik.util.Localhost;

public class StatelessTimeServer {
    private static TimeServiceIF _theTimeService;

    public static void main(String[] args) {
        try {
            String aJndiUrlProvider = "ubik://" + Localhost.getAnyLocalAddress().getHostAddress() + ":1099/";
            String aJndiInitialContext = "org.sapia.ubik.rmi.naming.remote.RemoteInitialContextFactory";
            if (args.length > 0) {
                aJndiUrlProvider = args[0];
                if (args.length > 1) {
                    aJndiInitialContext = args[1];
                }
            }
            _theTimeService = new StatelessTimeServiceImpl();
            Properties props = new Properties();
            props.setProperty("java.naming.provider.url", aJndiUrlProvider);
            props.setProperty("java.naming.factory.initial", aJndiInitialContext);
            props.setProperty("ubik.jndi.domain", "default");
            InitialContext context = new InitialContext(props);
            context.bind("util/timeService", (Object)_theTimeService);
            System.out.println("Time service bind and ready to rock");
            while (true) {
                Thread.sleep(100000L);
            }
        }
        catch (NamingException ne) {
            System.err.println("Error creating the JNDI context");
            ne.printStackTrace();
        }
        catch (InterruptedException ie) {
            System.err.println("The time server is interrupted and will exit");
            ie.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("System error running the time service");
            e.printStackTrace();
        }
    }
}

