/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.examples.time;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.sapia.ubik.rmi.examples.time.TimeServiceIF;
import org.sapia.ubik.rmi.naming.remote.RemoteInitialContextFactory;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;

public class TimeClient {
    private InitialContext _theContext;
    private TimeServiceIF _theTimeService;
    private boolean _isLogging;

    public TimeClient() {
        this(true);
    }

    public TimeClient(boolean isLogging) {
        try {
            Log.setInfo();
            this._isLogging = isLogging;
            Properties props = new Properties();
            props.setProperty("java.naming.provider.url", "ubik://localhost:1099/");
            props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
            props.setProperty("ubik.jndi.domain", "default");
            this._theContext = new InitialContext(props);
        }
        catch (Exception ne) {
            System.err.println("Error creating the JNDI context");
            ne.printStackTrace();
            throw new RuntimeException("Error creating the JNDI context - " + ne.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            Log.setWarning();
            new TimeClient().execute();
            Hub.shutdown(30000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void execute() {
        try {
            String aTime = this.getTimeService().getTime();
            if (this._isLogging) {
                System.out.println("Current time --> " + aTime);
            }
        }
        catch (NamingException ne) {
            System.err.println("Error looking up the time service");
            ne.printStackTrace();
        }
    }

    public TimeServiceIF getTimeService() throws NamingException {
        if (this._theTimeService == null) {
            Object anObject = this._theContext.lookup("util/timeService");
            if (anObject instanceof TimeServiceIF) {
                this._theTimeService = (TimeServiceIF)anObject;
            } else {
                throw new NamingException("The object received is not a TimeServiceIF: " + anObject);
            }
        }
        return this._theTimeService;
    }
}

