/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sapia.ubik.rmi.interceptor.Event;
import org.sapia.ubik.rmi.interceptor.Interceptor;
import org.sapia.ubik.rmi.interceptor.InterceptorInfo;
import org.sapia.ubik.rmi.interceptor.InvalidInterceptorException;
import org.sapia.ubik.rmi.server.Log;

public class MultiDispatcher {
    Map _interceptors = new HashMap();

    public void addInterceptor(Class event, Interceptor it) throws InvalidInterceptorException {
        Method m;
        Class<?> itClass = it.getClass();
        int idx = event.getName().lastIndexOf(46);
        String shortName = idx < 0 ? event.getName() : event.getName().substring(idx + 1);
        char[] content = shortName.toCharArray();
        content[0] = Character.toUpperCase(content[0]);
        shortName = "on" + new String(content);
        try {
            m = itClass.getMethod(shortName, event);
        }
        catch (Exception e) {
            throw new InvalidInterceptorException(e);
        }
        ArrayList<InterceptorInfo> interceptors = (ArrayList<InterceptorInfo>)this._interceptors.get(event);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorInfo>();
            this._interceptors.put(event, interceptors);
        }
        interceptors.add(new InterceptorInfo(it, m));
    }

    public void dispatch(Event event) {
        List interceptors = (List)this._interceptors.get(event.getClass());
        if (interceptors == null) {
            return;
        }
        for (int i = 0; i < interceptors.size(); ++i) {
            InterceptorInfo info = (InterceptorInfo)interceptors.get(i);
            try {
                info.method.invoke((Object)info.interceptor, event);
                continue;
            }
            catch (Throwable t) {
                Throwable t2;
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof InvocationTargetException && (t2 = ((InvocationTargetException)t).getTargetException()) instanceof RuntimeException) {
                    throw (RuntimeException)t2;
                }
                this.handleError(t);
            }
        }
    }

    protected void handleError(Throwable t) {
        Log.error(this.getClass(), (Object)t);
    }
}

