/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.sapia.ubik.rmi.interceptor.Event;
import org.sapia.ubik.rmi.interceptor.Interceptor;
import org.sapia.ubik.rmi.interceptor.InterceptorInfo;
import org.sapia.ubik.rmi.interceptor.InvalidInterceptorException;

public class SingleDispatcher {
    Map _interceptors = new HashMap();

    public void registerInterceptor(Class event, Interceptor it) throws InvalidInterceptorException {
        Method m;
        Class<?> itClass = it.getClass();
        int idx = event.getName().lastIndexOf(46);
        String shortName = idx < 0 ? event.getName() : event.getName().substring(idx + 1);
        char[] content = shortName.toCharArray();
        content[0] = Character.toUpperCase(content[0]);
        shortName = "on" + new String(content);
        try {
            m = itClass.getMethod(shortName, event);
        }
        catch (Exception e) {
            throw new InvalidInterceptorException(e);
        }
        if (this._interceptors.get(event) != null) {
            throw new InvalidInterceptorException("interceptor already registered for " + event.getName());
        }
        this._interceptors.put(event, new InterceptorInfo(it, m));
    }

    public void dispatch(Event event) {
        InterceptorInfo info = (InterceptorInfo)this._interceptors.get(event.getClass());
        if (info == null) {
            return;
        }
        try {
            info.method.invoke((Object)info.interceptor, event);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    protected void handleError(Throwable t) {
        t.printStackTrace();
    }
}

