/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.naming.ServiceHandler;
import org.sapia.ubik.rmi.naming.remote.proxy.JNDIHandler;

public class ServiceLocator {
    public static final int UNDEFINED_PORT = -1;
    public static final String HANDLER_PATTERN = "ubik.rmi.naming.service.handler";
    public static final String UBIK_SCHEME = "ubik";
    private static Map _handlers = new HashMap();

    public static Object lookup(String url) throws NameNotFoundException, NamingException {
        Uri uri;
        try {
            uri = Uri.parse(url);
        }
        catch (UriSyntaxException e) {
            NamingException exc = new NamingException("could not look up " + url);
            exc.setRootCause(e);
            throw exc;
        }
        ServiceHandler handler = (ServiceHandler)_handlers.get(uri.getScheme());
        if (handler == null) {
            throw new NamingException("no handler found for: " + uri.getScheme());
        }
        return handler.handleLookup(uri.getHost(), uri.getPort(), uri.getQueryString().getPath(), uri.getQueryString().getParameters());
    }

    public static void registerHandler(String scheme, ServiceHandler handler) throws IllegalStateException {
        if (_handlers.get(scheme) != null) {
            throw new IllegalStateException("service handler already registered for :" + scheme);
        }
        _handlers.put(scheme, handler);
    }

    static {
        ServiceLocator.registerHandler(UBIK_SCHEME, new JNDIHandler());
        String[] propNames = System.getProperties().keySet().toArray(new String[System.getProperties().size()]);
        for (int i = 0; i < propNames.length; ++i) {
            String propName = propNames[i];
            if (!propName.startsWith(HANDLER_PATTERN)) continue;
            String scheme = propName.substring(HANDLER_PATTERN.length() + 1);
            String className = System.getProperty(propName);
            if (className == null) {
                throw new IllegalStateException("no class name defined for transport provider: " + propName);
            }
            try {
                ServiceHandler handler = (ServiceHandler)Class.forName(className).newInstance();
                ServiceLocator.registerHandler(scheme, handler);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IllegalStateException("could not instantiate transport provider: " + className);
            }
        }
    }
}

