/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote;

import java.io.IOException;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Log;

public class ClientListener
implements AsyncEventListener {
    private EventChannel _channel;
    private ServerAddress _addr;

    public ClientListener(EventChannel channel, ServerAddress addr) {
        this._channel = channel;
        this._addr = addr;
    }

    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        if (evt.getType().equals("ubik/rmi/naming/client/publish")) {
            ServerAddress addr = this._channel.getView().getAddressFor(evt.getNode());
            try {
                if (addr != null) {
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)("Dispatching JNDI discovery event to expecting client: " + addr));
                    }
                    this._channel.dispatch(addr, "ubik/rmi/naming/server/disco", (Object)this._addr);
                } else {
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)"Dispatching JNDI discovery event to whole domain");
                    }
                    this._channel.dispatch("ubik/rmi/naming/server/disco", this._addr);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

