/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote;

import javax.naming.Context;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.naming.remote.JNDIServerHelper;
import org.sapia.ubik.rmi.naming.remote.RemoteContext;
import org.sapia.ubik.rmi.naming.remote.RemoteContextProvider;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.util.Localhost;

public class EmbeddableJNDIServer
implements Runnable,
RemoteContextProvider,
AsyncEventListener {
    private String _domain;
    private String _mcastAddr;
    private int _port;
    private int _mcastPort;
    private Thread _serverThread;
    private EventChannel _ec;
    private Context _root;
    private boolean _closed;
    private boolean _started;
    private Exception _startErr;

    public EmbeddableJNDIServer() {
        this("default", 1099, "231.173.5.7", 5454);
    }

    public EmbeddableJNDIServer(String domain, int port) {
        this(domain, port, "231.173.5.7", 5454);
    }

    public EmbeddableJNDIServer(String domain, int port, String mcastAddress, int mcastPort) {
        this._domain = domain;
        this._port = port;
        this._mcastAddr = mcastAddress;
        this._mcastPort = mcastPort;
    }

    public EventChannel getEventChannel() {
        if (this._ec == null) {
            throw new IllegalStateException("Multicast event channel not initialized");
        }
        return this._ec;
    }

    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        if (evt.getType().equals("ubik/rmi/naming/client/publish")) {
            try {
                this._ec.dispatch("ubik/rmi/naming/server/disco", new TCPAddress(Localhost.getAnyLocalAddress().getHostAddress(), this._port));
            }
            catch (Exception e) {
                Log.warning(this.getClass(), (Object)"Could not dispatch JNDI server publishing event", (Throwable)e);
            }
        }
    }

    public Context getRootContext() {
        if (this._root == null) {
            throw new IllegalStateException("Context not initialized");
        }
        return this._root;
    }

    @Override
    public RemoteContext getRemoteContext() {
        return (RemoteContext)this._root;
    }

    public void stop() {
        if (this._serverThread != null) {
            this._serverThread.interrupt();
            this.waitClosed();
        } else if (this._ec != null) {
            this._ec.close();
        }
    }

    public void start(boolean daemon) throws Exception {
        this._serverThread = new Thread((Runnable)this, "ubik.jndi:" + this._domain + ":" + this._port);
        this._serverThread.setDaemon(daemon);
        this._serverThread.start();
        this.waitStarted();
        if (this._startErr != null) {
            throw this._startErr;
        }
    }

    @Override
    public final void run() {
        try {
            this._ec = new EventChannel(this._domain, this._mcastAddr, this._mcastPort);
            this._ec.start();
            this._ec.registerAsyncListener("ubik/rmi/naming/client/publish", this);
            this._ec.dispatch("ubik/rmi/naming/server/publish", new TCPAddress(Localhost.getAnyLocalAddress().getHostAddress(), this._port));
            this._ec.dispatch("ubik/rmi/naming/server/disco", new TCPAddress(Localhost.getAnyLocalAddress().getHostAddress(), this._port));
            this._root = JNDIServerHelper.newRootContext(this._ec);
            Hub.exportObject((Object)this, this._port);
            Log.warning(this.getClass(), (Object)("Server started on port: " + this._port + ", domain: " + this._domain));
            this.notifyStarted();
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            Log.warning(this.getClass(), (Object)("Shutting down JNDI server: " + this._port + ", " + this._domain));
            this._ec.close();
            this.notifyClosed();
        }
        catch (Exception e) {
            this._startErr = e;
            this.notifyStarted();
        }
    }

    private synchronized void notifyClosed() {
        this._closed = true;
        this.notify();
    }

    private synchronized void notifyStarted() {
        this._started = true;
        this.notify();
    }

    private synchronized void waitClosed() {
        try {
            while (!this._closed) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this._ec.close();
        }
    }

    private synchronized void waitStarted() {
        try {
            while (!this._started) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }
}

