/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote;

import org.sapia.ubik.rmi.naming.remote.EmbeddableJNDIServer;
import org.sapia.ubik.rmi.naming.remote.JNDIServerHelper;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;

public class JNDIServer {
    public static void main(String[] args) {
        JNDIServerHelper.Args argsObj = JNDIServerHelper.parseArgs(args);
        if (argsObj != null) {
            try {
                EmbeddableJNDIServer server = new EmbeddableJNDIServer(argsObj.domain, argsObj.port, argsObj.mcastAddress, argsObj.mcastPort);
                server.start(false);
                Runtime.getRuntime().addShutdownHook(new ShutdownHook(server));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static final class ShutdownHook
    extends Thread {
        private EmbeddableJNDIServer _svr;

        ShutdownHook(EmbeddableJNDIServer svr) {
            this._svr = svr;
        }

        @Override
        public void run() {
            this._svr.stop();
            try {
                Hub.shutdown(30000L);
            }
            catch (InterruptedException e) {
                Log.error(this.getClass(), (Object)"JNDI server could not shut down properly", (Throwable)e);
            }
        }
    }
}

