/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.naming.remote.ClientListener;
import org.sapia.ubik.rmi.naming.remote.Consts;
import org.sapia.ubik.rmi.naming.remote.archie.UbikRemoteContext;

public class JNDIServerHelper
implements Consts {
    public static Args parseArgs(String[] args) {
        int mcastPort;
        String mcastAddress;
        String domain;
        int port;
        block11: {
            port = 1099;
            domain = "default";
            mcastAddress = "231.173.5.7";
            mcastPort = 5454;
            if (args.length > 0) {
                if (args[0].equals("-h")) {
                    JNDIServerHelper.help();
                    return null;
                }
                try {
                    port = Integer.parseInt(args[0]);
                    if (args.length == 2) {
                        domain = args[1];
                    }
                }
                catch (NumberFormatException e) {
                    domain = args[0];
                    if (args.length != 2) break block11;
                    try {
                        port = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e2) {
                        JNDIServerHelper.help();
                        return null;
                    }
                }
            }
        }
        try {
            if (System.getProperty("ubik.rmi.naming.mcast.post") != null) {
                mcastPort = Integer.parseInt(System.getProperty("ubik.rmi.naming.mcast.post"));
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid multicast port: " + System.getProperty("ubik.rmi.naming.mcast.post"));
            JNDIServerHelper.help();
            return null;
        }
        if (System.getProperty("ubik.rmi.naming.mcast.address") != null) {
            mcastAddress = System.getProperty("ubik.rmi.naming.mcast.address");
        }
        return new Args(port, domain, mcastAddress, mcastPort);
    }

    public static Context newRootContext(EventChannel ec) throws NamingException {
        return UbikRemoteContext.newInstance(ec);
    }

    public static ClientListener createClientListener(EventChannel ec, ServerAddress addr) throws NamingException, IOException {
        ClientListener listener = new ClientListener(ec, addr);
        ec.registerAsyncListener("ubik/rmi/naming/client/publish", listener);
        ec.dispatch("ubik/rmi/naming/server/publish", addr);
        return listener;
    }

    static final void help() {
        System.out.println();
        System.out.println("Syntax: jndi [<port>] [<domain>]");
        System.out.println("where:");
        System.out.println("<port>  := port on which JNDI server should listen (defaults to 1099).");
        System.out.println("<domain>:= domain name that JNDI server is part of (defaults to 'default').");
        System.out.println();
        System.out.println();
        System.exit(1);
    }

    public static class Args {
        int port;
        int mcastPort;
        String mcastAddress;
        String domain;

        Args(int port, String domain, String mcastAddress, int mcastPort) {
            this.port = port;
            this.domain = domain;
            this.mcastAddress = mcastAddress;
            this.mcastPort = mcastPort;
        }
    }
}

