/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.naming.remote.Consts;
import org.sapia.ubik.rmi.naming.remote.RemoteContext;
import org.sapia.ubik.rmi.naming.remote.proxy.ContextResolver;
import org.sapia.ubik.rmi.naming.remote.proxy.DefaultContextResolver;
import org.sapia.ubik.rmi.naming.remote.proxy.ReliableLocalContext;
import org.sapia.ubik.rmi.server.Log;

public class RemoteInitialContextFactory
implements InitialContextFactory,
Consts {
    private String _scheme = "ubik";

    public RemoteInitialContextFactory() {
    }

    public RemoteInitialContextFactory(String serviceLocatorScheme) {
        this._scheme = serviceLocatorScheme;
    }

    public Context getInitialContext(Hashtable props) throws NamingException {
        String url = (String)props.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("java.naming.provider.url property not specified");
        }
        Uri uri = null;
        try {
            uri = Uri.parse(url);
        }
        catch (UriSyntaxException e) {
            NamingException ne = new NamingException("Invalid URL:" + url);
            ne.setRootCause(e);
            throw ne;
        }
        uri.setScheme(this._scheme);
        String domain = props.get("ubik.jndi.domain") == null ? "default" : (String)props.get("ubik.jndi.domain");
        String mcastAddr = "231.173.5.7";
        int mcastPort = 5454;
        if (props.get("ubik.rmi.naming.mcast.address") != null) {
            mcastAddr = (String)props.get("ubik.rmi.naming.mcast.address");
        }
        if (props.get("ubik.rmi.naming.mcast.post") != null) {
            try {
                mcastPort = Integer.parseInt((String)props.get("ubik.rmi.naming.mcast.post"));
            }
            catch (NumberFormatException e) {
                throw new NamingException("Invalid multicast port: " + mcastPort);
            }
        }
        EventChannel ec = null;
        RemoteContext ctx = null;
        ContextResolver resolver = this.doGetResolver();
        try {
            ec = new EventChannel(domain, mcastAddr, mcastPort);
            ec.start();
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not start event channel");
            ne.setRootCause(e);
            throw ne;
        }
        try {
            ctx = this.doGetResolver().resolve(uri.getHost(), uri.getPort());
        }
        catch (RemoteException e) {
            Log.warning(this.getClass(), (Object)("Could not find JNDI server for : " + uri.toString() + "; trying to discover"));
            BlockingEventListener listener = new BlockingEventListener();
            ec.registerAsyncListener("ubik/rmi/naming/server/disco", listener);
            TCPAddress addr = null;
            try {
                ec.dispatch("ubik/rmi/naming/client/publish", "");
                RemoteEvent evt = listener.waitForEvent(10000L);
                ec.unregisterListener(listener);
                if (evt == null) {
                    NamingException ne = new NamingException("could not connect to JNDI server");
                    ne.setRootCause(e);
                    throw ne;
                }
                addr = (TCPAddress)evt.getData();
                Log.warning(this.getClass(), (Object)("Discovered JNDI server at : " + addr));
                ctx = resolver.resolve(addr);
                return new ReliableLocalContext(ec, uri.toString(), ctx, false, resolver);
            }
            catch (Exception e2) {
                NamingException ne = new NamingException("Could not connect to remote JNDI server: " + addr);
                ne.setRootCause(e2);
                throw ne;
            }
        }
        try {
            return new ReliableLocalContext(ec, uri.toString(), ctx, true, resolver);
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not instantiate local context");
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected ContextResolver doGetResolver() {
        return new DefaultContextResolver();
    }

    static final class BlockingEventListener
    implements AsyncEventListener {
        private RemoteEvent _evt;

        BlockingEventListener() {
        }

        @Override
        public synchronized void onAsyncEvent(RemoteEvent evt) {
            this._evt = evt;
            this.notify();
        }

        public synchronized RemoteEvent waitForEvent(long timeout) {
            long start = System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() - start < timeout && this._evt == null) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                return null;
            }
            return this._evt;
        }
    }
}

