/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote.archie;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.sapia.archie.Node;
import org.sapia.archie.ProcessingException;
import org.sapia.archie.jndi.JndiContext;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.rmi.naming.remote.DomainInfo;
import org.sapia.ubik.rmi.naming.remote.RemoteContext;
import org.sapia.ubik.rmi.naming.remote.archie.UbikNamingEnum;
import org.sapia.ubik.rmi.naming.remote.archie.UbikNodeFactory;
import org.sapia.ubik.rmi.naming.remote.archie.UbikSyncNode;
import org.sapia.ubik.rmi.naming.remote.archie.UbikSynchronizer;

public class UbikRemoteContext
extends JndiContext
implements RemoteContext {
    private DomainInfo _domain;

    protected UbikRemoteContext(DomainInfo domain, Node root) {
        super(root);
        this._domain = domain;
    }

    protected UbikRemoteContext(UbikSyncNode node) {
        super((Node)node);
        EventChannel channel = ((UbikSynchronizer)node.getSynchronizer()).getEventChannel();
        this._domain = new DomainInfo(channel.getDomainName(), channel.getMulticastHost(), channel.getMulticastPort());
    }

    @Override
    public DomainInfo getDomainInfo() {
        return this._domain;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        super.rebind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        super.rebind(name, obj);
    }

    protected Context newChildContext(Node node) {
        UbikSyncNode sync = (UbikSyncNode)node;
        return new UbikRemoteContext(sync);
    }

    protected NamingEnumeration newNamingEnum(Iterator entries, Iterator childNodes, int listType) {
        return new UbikNamingEnum(entries, childNodes, listType);
    }

    public static UbikRemoteContext newInstance(EventChannel channel) throws NamingException {
        UbikSynchronizer sync = new UbikSynchronizer(channel);
        UbikNodeFactory fac = new UbikNodeFactory(sync);
        try {
            UbikSyncNode root = new UbikSyncNode(fac);
            root.setSynchronizer(sync);
            sync.setRoot(root);
            return new UbikRemoteContext(new DomainInfo(channel.getDomainName(), channel.getMulticastHost(), channel.getMulticastPort()), (Node)root);
        }
        catch (ProcessingException e) {
            NamingException ne = new NamingException("Could not create remote context");
            ne.setRootCause(e);
            throw ne;
        }
    }
}

