/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote.archie;

import java.io.IOException;
import javax.naming.NamingException;
import org.sapia.archie.Archie;
import org.sapia.archie.Name;
import org.sapia.archie.NamePart;
import org.sapia.archie.Node;
import org.sapia.archie.NotFoundException;
import org.sapia.archie.sync.SynchronizedNode;
import org.sapia.archie.sync.Synchronizer;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.ListenerAlreadyRegisteredException;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.mcast.RespList;
import org.sapia.ubik.mcast.Response;
import org.sapia.ubik.mcast.SyncEventListener;
import org.sapia.ubik.rmi.naming.remote.archie.SyncGetEvent;
import org.sapia.ubik.rmi.naming.remote.archie.SyncPutEvent;
import org.sapia.ubik.rmi.naming.remote.archie.SyncRemoveEvent;

public class UbikSynchronizer
implements Synchronizer,
AsyncEventListener,
SyncEventListener {
    private EventChannel _channel;
    private Archie _root;

    UbikSynchronizer(EventChannel channel) throws NamingException {
        this._channel = channel;
        this._channel = channel;
        this._channel.registerAsyncListener(SyncPutEvent.class.getName(), this);
        try {
            this._channel.registerSyncListener(SyncGetEvent.class.getName(), this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            NamingException ne = new NamingException("Could not start event channel");
            ne.setRootCause(e);
            throw ne;
        }
        if (!this._channel.isStarted()) {
            if (this._channel.isClosed()) {
                throw new IllegalStateException("Event channel is closed!");
            }
            try {
                this._channel.start();
            }
            catch (IOException e) {
                NamingException ne = new NamingException("Could not start event channel");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    public EventChannel getEventChannel() {
        return this._channel;
    }

    public void setRoot(SynchronizedNode root) {
        this._root = new Archie((Node)root);
    }

    public Object onGetValue(Name nodeAbsolutePath, NamePart valueName) {
        RespList results;
        Response toReturn = null;
        try {
            results = this._channel.send(SyncGetEvent.class.getName(), new SyncGetEvent(nodeAbsolutePath, valueName));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        for (int i = 0; i < results.count(); ++i) {
            toReturn = results.get(i);
            if (toReturn.getData() == null || toReturn.isError()) continue;
            return toReturn.getData();
        }
        return null;
    }

    public void onPutValue(Name nodeAbsolutePath, NamePart valueName, Object value, boolean overwrite) {
        SyncPutEvent evt = new SyncPutEvent(nodeAbsolutePath, valueName, value, overwrite);
        try {
            this._channel.dispatch(SyncPutEvent.class.getName(), evt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onRemoveValue(Name nodeAbsolutePath, NamePart name) {
        SyncRemoveEvent evt = new SyncRemoveEvent(nodeAbsolutePath, name);
        try {
            this._channel.dispatch(SyncRemoveEvent.class.getName(), evt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        if (evt.getType().equals(SyncPutEvent.class.getName())) {
            try {
                SyncPutEvent put = (SyncPutEvent)evt.getData();
                SynchronizedNode node = (SynchronizedNode)this.root().lookupNode(put.getNodePath(), true);
                node.synchronizePut(put.getName(), put.getValue(), true);
            }
            catch (NotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object onSyncEvent(RemoteEvent evt) {
        if (evt.getType().equals(SyncGetEvent.class.getName())) {
            try {
                SyncGetEvent get = (SyncGetEvent)evt.getData();
                SynchronizedNode node = (SynchronizedNode)this.root().lookupNode(get.getNodePath(), true);
                return node.synchronizeGet(get.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
        }
        return null;
    }

    private Archie root() {
        if (this._root == null) {
            throw new IllegalStateException("Root node was not set");
        }
        return this._root;
    }
}

