/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote.discovery;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import org.sapia.archie.Name;
import org.sapia.archie.impl.AttributeNameParser;
import org.sapia.archie.impl.AttributeNamePart;
import org.sapia.archie.impl.DefaultNameParser;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.naming.remote.RemoteContext;
import org.sapia.ubik.rmi.naming.remote.archie.SyncPutEvent;
import org.sapia.ubik.rmi.naming.remote.discovery.JndiDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoveryEvent;
import org.sapia.ubik.rmi.naming.remote.proxy.ContextResolver;
import org.sapia.ubik.rmi.naming.remote.proxy.DefaultContextResolver;
import org.sapia.ubik.rmi.naming.remote.proxy.LocalContext;
import org.sapia.ubik.rmi.server.Log;

public class DiscoveryHelper
implements AsyncEventListener {
    protected EventChannel _channel;
    private List _svclisteners = Collections.synchronizedList(new ArrayList());
    private List _jndiListeners = Collections.synchronizedList(new ArrayList());
    private ContextResolver _resolver = new DefaultContextResolver();

    public DiscoveryHelper(EventChannel ec) {
        this._channel = ec;
        this.initChannel();
    }

    public DiscoveryHelper(String domain) throws IOException {
        this._channel = new EventChannel(domain, "231.173.5.7", 5454);
        this._channel.start();
        this.initChannel();
    }

    public DiscoveryHelper(String domain, String mcastAddr, int mcastPort) throws IOException {
        this._channel = new EventChannel(domain, mcastAddr, mcastPort);
        this._channel.start();
        this.initChannel();
    }

    public void setContextResolver(ContextResolver res) {
        this._resolver = res;
    }

    public synchronized void addServiceDiscoListener(ServiceDiscoListener listener) {
        if (!this._svclisteners.contains(listener)) {
            this._svclisteners.add(listener);
        }
    }

    public synchronized void removeServiceDiscoListener(ServiceDiscoListener listener) {
        ArrayList listeners = new ArrayList(this._svclisteners);
        listeners.remove(listener);
        this._svclisteners = listeners;
    }

    public synchronized void addJndiDiscoListener(JndiDiscoListener listener) {
        if (!this._jndiListeners.contains(listener)) {
            this._jndiListeners.add(listener);
            try {
                this._channel.dispatch("ubik/rmi/naming/client/publish", "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeJndiDiscoListener(JndiDiscoListener listener) {
        ArrayList listeners = new ArrayList(this._jndiListeners);
        listeners.remove(listener);
        this._jndiListeners = listeners;
    }

    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        block14: {
            try {
                if (evt.getType().equals("ubik/rmi/naming/server/publish") || evt.getType().equals("ubik/rmi/naming/server/disco")) {
                    TCPAddress tcp = (TCPAddress)evt.getData();
                    Remote remoteCtx = this._resolver.resolve(tcp);
                    ArrayList listeners = new ArrayList(this._jndiListeners);
                    if (remoteCtx instanceof RemoteContext) {
                        try {
                            remoteCtx = new LocalContext(this.getJndiURI(tcp), (RemoteContext)remoteCtx);
                        }
                        catch (NamingException e) {
                            Log.warning(this.getClass(), (Object)"Could not create local context", (Throwable)e);
                            return;
                        }
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        ((JndiDiscoListener)listeners.get(i)).onJndiDiscovered((Context)((Object)remoteCtx));
                    }
                    break block14;
                }
                if (!evt.getType().equals(SyncPutEvent.class.getName())) break block14;
                SyncPutEvent bevt = (SyncPutEvent)evt.getData();
                try {
                    String name;
                    Properties props;
                    Name nameObj = bevt.getNodePath().add(bevt.getName());
                    if (bevt.getName() instanceof AttributeNamePart) {
                        props = ((AttributeNamePart)bevt.getName()).getAttributes();
                        name = new AttributeNameParser().asString(nameObj);
                    } else {
                        props = new Properties();
                        name = new DefaultNameParser().asString(nameObj);
                    }
                    ServiceDiscoveryEvent sevt = new ServiceDiscoveryEvent(props, name, bevt.getValue());
                    ArrayList listeners = new ArrayList(this._svclisteners);
                    for (int i = 0; i < listeners.size(); ++i) {
                        ServiceDiscoListener listener = (ServiceDiscoListener)listeners.get(i);
                        listener.onServiceDiscovered(sevt);
                    }
                }
                catch (IOException e) {
                    Log.warning(this.getClass(), (Object)"Caught connection error", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    Log.warning(this.getClass(), (Object)"Class not found deserializing event", (Throwable)e);
                }
            }
            catch (RemoteException e) {
                Log.warning(this.getClass(), (Object)"Caught connection error", (Throwable)e);
            }
            catch (IOException e) {
                Log.warning(this.getClass(), (Object)"Caught IO error", (Throwable)e);
            }
        }
    }

    public synchronized void close() {
        this._channel.close();
    }

    public synchronized EventChannel getChannel() {
        return this._channel;
    }

    void initChannel() {
        this._channel.registerAsyncListener("ubik/rmi/naming/server/publish", this);
        this._channel.registerAsyncListener("ubik/rmi/naming/server/disco", this);
        this._channel.registerAsyncListener(SyncPutEvent.class.getName(), this);
    }

    protected String getJndiURI(TCPAddress addr) {
        return new StringBuffer("ubik").append("://").append(addr.getHost()).append(":").append(addr.getPort()).toString();
    }
}

