/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote.proxy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.sapia.ubik.mcast.DomainName;
import org.sapia.ubik.rmi.naming.remote.StubTweaker;
import org.sapia.ubik.rmi.server.Stub;
import org.sapia.ubik.rmi.server.StubInvocationHandler;

public class BindingCache
implements Externalizable {
    private List _services = Collections.synchronizedList(new ArrayList());

    public synchronized void add(String domainName, Name name, Object o) {
        this._services.add(new BoundRef(domainName, name, o));
    }

    public synchronized List cachedRefs() {
        return this._services;
    }

    public void copyTo(Context ctx, DomainName domain, String baseUrl, String mcastAddress, int mcastPort) {
        for (int i = 0; i < this._services.size(); ++i) {
            BoundRef ref = (BoundRef)this._services.get(i);
            if (ref.obj == null) continue;
            try {
                Object toBind;
                if (ref.domainName == null || !domain.contains(ref.domainName) || (toBind = ref.obj instanceof SoftReference ? ((SoftReference)ref.obj).get() : ref.obj) == null) continue;
                toBind = StubTweaker.tweak(baseUrl, ref.name, ref.domainName, mcastAddress, mcastPort, toBind);
                ctx.rebind(ref.name, toBind);
                continue;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._services = (List)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        List list = this._services;
        synchronized (list) {
            for (int i = 0; i < this._services.size(); ++i) {
                BoundRef ref = (BoundRef)this._services.get(i);
                if (!ref.isNull()) continue;
                this._services.remove(i);
                --i;
            }
        }
        out.writeObject(this._services);
    }

    public static class BoundRef
    implements Externalizable {
        public Name name;
        public Object obj;
        public DomainName domainName;

        public BoundRef() {
        }

        BoundRef(String domainName, Name name, Object o) {
            this.domainName = DomainName.parse(domainName);
            this.name = name;
            this.obj = new SoftReference<Object>(o);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (Name)in.readObject();
            this.obj = in.readObject();
            this.domainName = (DomainName)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            InvocationHandler handler;
            out.writeObject(this.name);
            Object toWrite = this.obj instanceof SoftReference ? ((SoftReference)this.obj).get() : this.obj;
            if (toWrite instanceof Stub && Proxy.isProxyClass(toWrite.getClass()) && (handler = Proxy.getInvocationHandler(toWrite)) instanceof StubInvocationHandler) {
                toWrite = ((StubInvocationHandler)handler).toStubContainer(toWrite);
            }
            out.writeObject(toWrite);
            out.writeObject(this.domainName);
        }

        public boolean isNull() {
            if (this.obj == null) {
                return true;
            }
            if (this.obj instanceof SoftReference) {
                return ((SoftReference)this.obj).get() == null;
            }
            return false;
        }
    }
}

