/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.naming.remote.proxy;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.naming.remote.RemoteContext;
import org.sapia.ubik.rmi.naming.remote.discovery.DiscoveryHelper;
import org.sapia.ubik.rmi.naming.remote.discovery.JndiDiscoListener;
import org.sapia.ubik.rmi.naming.remote.discovery.ServiceDiscoListener;
import org.sapia.ubik.rmi.naming.remote.proxy.BindingCache;
import org.sapia.ubik.rmi.naming.remote.proxy.ContextResolver;
import org.sapia.ubik.rmi.naming.remote.proxy.LocalContext;
import org.sapia.ubik.rmi.server.Log;

public class ReliableLocalContext
extends LocalContext
implements AsyncEventListener {
    private static ThreadLocal _currentContext = new ThreadLocal();
    private static String PING = "ubik/rmi/naming/ping/test";
    private BindingCache _bindings = new BindingCache();
    private DiscoveryHelper _helper;
    private List _servers = Collections.synchronizedList(new ArrayList());
    private ContextResolver _resolver;

    public ReliableLocalContext(EventChannel channel, String url, RemoteContext ctx, boolean publish, ContextResolver resolver) throws NamingException, IOException {
        super(url, ctx);
        this._helper = new DiscoveryHelper(channel);
        this._resolver = resolver;
        channel.registerAsyncListener("ubik/rmi/naming/server/disco", this);
        channel.registerAsyncListener("ubik/rmi/naming/server/publish", this);
        if (publish && !channel.isClosed()) {
            channel.dispatch("ubik/rmi/naming/client/publish", "");
        }
        _currentContext.set(this);
    }

    @Override
    public void bind(Name n, Object o) throws NamingException {
        this.rebind(n, o);
    }

    @Override
    public void bind(String n, Object o) throws NamingException {
        this.rebind(n, o);
    }

    @Override
    public void rebind(Name n, Object o) throws NamingException {
        super.rebind(n, o);
        if (!this._helper.getChannel().isClosed()) {
            this._bindings.add(this._helper.getChannel().getDomainName().toString(), n, o);
        }
    }

    @Override
    public void rebind(String n, Object o) throws NamingException {
        super.rebind(n, o);
        if (!this._helper.getChannel().isClosed()) {
            this._bindings.add(this._helper.getChannel().getDomainName().toString(), super.getNameParser().parse(n), o);
        }
    }

    public void addServiceDiscoListener(ServiceDiscoListener listener) {
        if (!this._helper.getChannel().isClosed()) {
            this._helper.addServiceDiscoListener(listener);
        }
    }

    public void addJndiDiscoListener(JndiDiscoListener listener) {
        if (!this._helper.getChannel().isClosed()) {
            this._helper.addJndiDiscoListener(new JndiListenerWrapper(listener));
        }
    }

    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        try {
            if (evt.getType().equals("ubik/rmi/naming/server/disco")) {
                TCPAddress tcp = (TCPAddress)evt.getData();
                RemoteContext remoteCtx = this._resolver.resolve(tcp);
                this._servers.add(remoteCtx);
                this._bindings.copyTo(remoteCtx, this._domainName, this._url, this._helper.getChannel().getMulticastHost(), this._helper.getChannel().getMulticastPort());
            } else if (evt.getType().equals("ubik/rmi/naming/server/publish") && this.getInternalContext() != null) {
                Log.info(this.getClass(), (Object)"Discovered naming service; binding cached stubs...");
                TCPAddress tcp = (TCPAddress)evt.getData();
                RemoteContext remoteCtx = this._resolver.resolve(tcp);
                this._servers.add(remoteCtx);
                this._bindings.copyTo(remoteCtx, this._domainName, this._url, this._helper.getChannel().getMulticastHost(), this._helper.getChannel().getMulticastPort());
            }
        }
        catch (RemoteException e) {
            Log.error(this.getClass(), (Object)"Could not connect to naming service", (Throwable)e);
        }
        catch (IOException e) {
            Log.error(this.getClass(), (Object)"IO problem trying to bind services", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFailOver(UndeclaredThrowableException e) throws NamingException {
        if (!(e.getUndeclaredThrowable() instanceof RemoteException)) {
            super.doFailOver(e);
        }
        List list = this._servers;
        synchronized (list) {
            for (int i = 0; i < this._servers.size(); ++i) {
                RemoteContext server = (RemoteContext)this._servers.get(i);
                try {
                    server.lookup(PING);
                    this._ctx = server;
                    return;
                }
                catch (UndeclaredThrowableException udte) {
                    if (!(udte.getUndeclaredThrowable() instanceof RemoteException)) continue;
                    this._servers.remove(i);
                    continue;
                }
                catch (NamingException ne) {
                    this._ctx = server;
                    return;
                }
            }
        }
        super.doFailOver(e);
    }

    @Override
    public void close() throws NamingException {
        super.close();
        this._helper.close();
    }

    public static ReliableLocalContext currentContext() throws IllegalStateException {
        ReliableLocalContext ctx = (ReliableLocalContext)_currentContext.get();
        if (ctx == null) {
            throw new IllegalStateException("No " + ReliableLocalContext.class.getName() + " registered with current thread");
        }
        return ctx;
    }

    public EventChannel getEventChannel() {
        return this._helper.getChannel();
    }

    class JndiListenerWrapper
    implements JndiDiscoListener {
        private JndiDiscoListener _wrapped;

        JndiListenerWrapper(JndiDiscoListener toWrap) {
            this._wrapped = toWrap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJndiDiscovered(Context ctx) {
            List list = ReliableLocalContext.this._servers;
            synchronized (list) {
                ReliableLocalContext.this._servers.add(ctx);
            }
            this._wrapped.onJndiDiscovered(ctx);
        }
    }
}

