/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.replication;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.replication.ReplicatedInvoker;
import org.sapia.ubik.rmi.replication.ReplicationEvent;
import org.sapia.ubik.rmi.replication.ReplicationStrategy;
import org.sapia.ubik.rmi.replication.SendHelper;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;

public abstract class ReplicatedCommand
extends InvokeCommand {
    private Set _visited = new HashSet();
    private Set _targets;
    private ReplicatedInvoker _invoker;
    private boolean _executed;
    private boolean _synchronous;
    private boolean _disabled;

    public ReplicatedCommand() {
    }

    public ReplicatedCommand(InvokeCommand cmd, Set targets, ReplicatedInvoker invoker, boolean synchronous) {
        super(cmd.getOID(), cmd.getMethodName(), cmd.getParams(), cmd.getParameterTypes(), null);
        this._targets = targets;
        this._invoker = invoker;
        this._synchronous = synchronous;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object execute() throws Throwable {
        Object toReturn;
        if (this._disabled) {
            return super.execute();
        }
        Hub.serverRuntime.dispatchEvent(new ReplicationEvent(this));
        Set siblings = this._invoker.getSiblings();
        ReplicationStrategy strat = new ReplicationStrategy(this._visited, this._targets, siblings);
        ServerAddress current = this.getServerAddress();
        if (this._executed) {
            this.convertParams(this._invoker.getClass().getClassLoader());
            return this._invoker.invoke(super.getMethodName(), super.getParameterTypes(), super.getParams());
        }
        if (this._targets != null) {
            if (!this._targets.contains(current)) {
                this._executed = true;
                return this.send(strat.selectNextSibling());
            }
            toReturn = super.execute();
            this._executed = true;
            this._targets.remove(current);
        } else {
            toReturn = super.execute();
            this._executed = true;
        }
        ServerAddress addr = strat.selectNextSibling();
        if (addr == null) return toReturn;
        if (this._disabled) return toReturn;
        this.send(addr);
        return toReturn;
    }

    public ReplicatedInvoker getReplicatedInvoker() {
        return this._invoker;
    }

    public void disable() {
        this._disabled = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._visited = (Set)in.readObject();
        this._targets = (Set)in.readObject();
        this._invoker = (ReplicatedInvoker)in.readObject();
        this._executed = in.readBoolean();
        this._synchronous = in.readBoolean();
        this._disabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._visited);
        out.writeObject(this._targets);
        out.writeObject(this._invoker);
        out.writeBoolean(this._executed);
        out.writeBoolean(this._synchronous);
        out.writeBoolean(this._disabled);
    }

    protected Object send(ServerAddress next) throws RemoteException {
        SendHelper helper = new SendHelper(this, next, this._synchronous);
        if (this._synchronous) {
            try {
                return helper.send();
            }
            catch (Throwable t) {
                if (t instanceof RemoteException) {
                    throw (RemoteException)t;
                }
                throw new RemoteException("Exception caught replicating command", t);
            }
        }
        try {
            helper.send();
        }
        catch (Throwable t) {
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            throw new RemoteException("Exception caught replicating command", t);
        }
        return null;
    }

    protected Set getVisitedAddresses() {
        return this._visited;
    }

    protected Set getTargetAddresses() {
        return this._targets;
    }
}

