/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.replication;

import java.io.IOException;
import java.rmi.RemoteException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;

class SendHelper
implements Runnable {
    private Object _toSend;
    private ServerAddress _addr;
    private boolean _sync;

    SendHelper(Object toSend, ServerAddress addr, boolean sync) {
        this._toSend = toSend;
        this._addr = addr;
        this._sync = sync;
    }

    @Override
    public void run() {
        try {
            this.doSend();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    Object send() throws Throwable {
        if (this._sync) {
            return this.doSend();
        }
        Thread t = new Thread(this);
        t.setName("ubik.rmi.SendHelper");
        t.setDaemon(true);
        t.start();
        return null;
    }

    private Object doSend() throws Throwable {
        Object toReturn;
        Connections conns = TransportManager.getConnectionsFor(this._addr);
        RmiConnection conn = conns.acquire();
        try {
            conn.send(this._toSend);
            toReturn = conn.receive();
        }
        catch (RemoteException e) {
            conn.close();
            throw e;
        }
        catch (IOException e) {
            RemoteException re = new RemoteException("Could not send replicated command", e);
            conn.close();
            throw re;
        }
        catch (ClassNotFoundException e) {
            RemoteException re = new RemoteException("Could not receive response for replicated command", e);
            conn.close();
            throw re;
        }
        conns.release(conn);
        return toReturn;
    }
}

