/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.interceptor.Event;
import org.sapia.ubik.rmi.interceptor.Interceptor;
import org.sapia.ubik.rmi.interceptor.InvalidInterceptorException;
import org.sapia.ubik.rmi.interceptor.MultiDispatcher;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.gc.ClientGC;
import org.sapia.ubik.rmi.server.invocation.InvocationDispatcher;
import org.sapia.ubik.taskman.TaskManager;

public class ClientRuntime {
    static final InvocationDispatcher invoker = new InvocationDispatcher();
    private static Map _serverAddresses = new HashMap();
    public final MultiDispatcher dispatcher = new MultiDispatcher();
    final ClientGC gc;

    ClientRuntime(TaskManager taskman) {
        this.gc = new ClientGC(taskman);
    }

    boolean isCallback(String transportType) {
        if (_serverAddresses.get(transportType) == null) {
            this.doInit(transportType);
        }
        return _serverAddresses.get(transportType) != null;
    }

    void shutdown(long timeout) throws InterruptedException {
    }

    public ServerAddress getCallbackAddress(String transportType) throws IllegalStateException {
        if (_serverAddresses.get(transportType) == null) {
            throw new IllegalStateException("no callback server was instantiated; make sure the following system property is set to 'true' upon VM startup: ubik.rmi.callback.enabled");
        }
        return (ServerAddress)_serverAddresses.get(transportType);
    }

    public synchronized void addInterceptor(Class eventClass, Interceptor it) throws InvalidInterceptorException {
        this.dispatcher.addInterceptor(eventClass, it);
    }

    public void dispatchEvent(Event event) {
        this.dispatcher.dispatch(event);
    }

    synchronized void doInit(String transportType) {
        if (System.getProperty("ubik.rmi.callback.enabled") != null && System.getProperty("ubik.rmi.callback.enabled").equalsIgnoreCase("true")) {
            if (_serverAddresses.get(transportType) != null) {
                return;
            }
            Log.warning(this.getClass(), (Object)("Creating server to receive callbacks on transport: " + transportType));
            ServerAddress serverAddress = null;
            if (Hub.serverRuntime.server.isInit(transportType)) {
                serverAddress = Hub.serverRuntime.server.getServerAddress(transportType);
            } else {
                try {
                    serverAddress = Hub.serverRuntime.server.init(transportType);
                }
                catch (RemoteException e) {
                    Log.error(ClientRuntime.class, (Object)e);
                }
            }
            _serverAddresses.put(transportType, serverAddress);
        }
    }
}

