/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.rmi.RemoteRuntimeException;

class EventChannelSingleton {
    private static Map _channels = new HashMap();
    private static String _mcastAddress = "231.173.5.7";
    private static int _mcastPort = 5454;

    EventChannelSingleton() {
    }

    static synchronized EventChannel getEventChannelFor(String domain) throws RemoteRuntimeException {
        return EventChannelSingleton.getEventChannelFor(domain, _mcastAddress, _mcastPort);
    }

    static synchronized EventChannel getEventChannelFor(String domain, String mcastAddress, int mcastPort) throws RemoteRuntimeException {
        String key = domain + ":" + mcastAddress + ":" + mcastPort;
        EventChannel channel = (EventChannel)_channels.get(key);
        if (channel == null) {
            try {
                channel = new EventChannel(domain, mcastAddress, mcastPort);
                channel.start();
            }
            catch (IOException e) {
                throw new RemoteRuntimeException("Could not create event channel for domain: " + domain, e);
            }
            _channels.put(key, channel);
        }
        return channel;
    }

    static synchronized void shutdown() {
        for (EventChannel channel : _channels.values()) {
            channel.close();
        }
        _channels.clear();
    }

    static {
        try {
            if (System.getProperty("ubik.rmi.naming.mcast.post") != null) {
                _mcastPort = Integer.parseInt(System.getProperty("ubik.rmi.naming.mcast.post"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (System.getProperty("ubik.rmi.naming.mcast.address") != null) {
            _mcastAddress = System.getProperty("ubik.rmi.naming.mcast.address");
        }
    }
}

