/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.Name;
import org.sapia.ubik.jmx.JmxHelper;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.ClientRuntime;
import org.sapia.ubik.rmi.server.CommandConnect;
import org.sapia.ubik.rmi.server.EventChannelSingleton;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.ObjectTable;
import org.sapia.ubik.rmi.server.RemoteRef;
import org.sapia.ubik.rmi.server.RemoteRefEx;
import org.sapia.ubik.rmi.server.RemoteRefReliable;
import org.sapia.ubik.rmi.server.RemoteRefStateless;
import org.sapia.ubik.rmi.server.ServerRef;
import org.sapia.ubik.rmi.server.ServerRuntime;
import org.sapia.ubik.rmi.server.ServerTable;
import org.sapia.ubik.rmi.server.Stub;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.gc.CommandRefer;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Statistic;
import org.sapia.ubik.rmi.server.perf.StatsCollector;
import org.sapia.ubik.rmi.server.perf.Topic;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;
import org.sapia.ubik.taskman.TaskManager;
import org.sapia.ubik.taskman.TaskManagerFactory;

public class Hub {
    public static final StatsCollector statsCollector;
    public static final TaskManager taskMan;
    public static final ClientRuntime clientRuntime;
    public static final ServerRuntime serverRuntime;
    static final Perf _perf;
    static boolean _callback;
    static boolean _shutdown;
    private static Statistic _freeMemory;
    private static Statistic _maxMemory;
    private static Statistic _totalMemory;

    public static Object toStub(Object o) throws RemoteException {
        if (o instanceof Stub) {
            return o;
        }
        if (!Hub.serverRuntime.server.isInit("tcp/socket")) {
            Hub.serverRuntime.server.init(o, "tcp/socket");
            ServerRef ref = Hub.serverRuntime.server.getServerRef("tcp/socket");
            return ref.stub;
        }
        return Hub.getStubFor(Hub.serverRuntime.server.initStub(o, "tcp/socket"), o);
    }

    public static Object toReliableStub(Object obj) {
        if (obj instanceof Stub && Proxy.isProxyClass(obj.getClass())) {
            RemoteRef handler = (RemoteRef)Proxy.getInvocationHandler(obj);
            RemoteRefReliable rmiHandler = new RemoteRefReliable(handler.getOid(), handler.getServerAddress());
            rmiHandler.setCallBack(handler.isCallBack());
            ObjectTable.Ref ref = (ObjectTable.Ref)Hub.serverRuntime.objectTable.getRefs().get(handler.getOid());
            if (ref == null) {
                throw new NullPointerException("no object for: " + handler.getOid());
            }
            Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ServerTable.getInterfacesFor(ref._obj.getClass()), (InvocationHandler)rmiHandler);
            return proxy;
        }
        return obj;
    }

    public static Object toStatelessStub(Name name, String domain, Object obj) {
        if (obj instanceof Stub && Proxy.isProxyClass(obj.getClass())) {
            RemoteRef handler = (RemoteRef)Proxy.getInvocationHandler(obj);
            ArrayList<RemoteRef> lst = new ArrayList<RemoteRef>(1);
            lst.add(handler);
            RemoteRefStateless rmiHandler = RemoteRefStateless.fromRemoteRefs(name, domain, lst);
            ObjectTable.Ref ref = (ObjectTable.Ref)Hub.serverRuntime.objectTable.getRefs().get(handler.getOid());
            if (ref == null) {
                throw new NullPointerException("no object for: " + handler.getOid());
            }
            Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ServerTable.getInterfacesFor(ref._obj.getClass()), (InvocationHandler)rmiHandler);
            return proxy;
        }
        return obj;
    }

    public static Object exportObject(Object o) throws RemoteException {
        if (!Hub.serverRuntime.server.isInit("tcp/socket")) {
            Hub.serverRuntime.server.init(o, "tcp/socket");
            ServerRef ref = Hub.serverRuntime.server.getServerRef("tcp/socket");
            return ref.stub;
        }
        return Hub.getStubFor(Hub.serverRuntime.server.initStub(o, "tcp/socket"), o);
    }

    public static Object exportObject(Object o, int port) throws RemoteException {
        if (!Hub.serverRuntime.server.isInit("tcp/socket")) {
            Hub.serverRuntime.server.init(o, port);
            ServerRef ref = Hub.serverRuntime.server.getServerRef("tcp/socket");
            return ref.stub;
        }
        return Hub.getStubFor(Hub.serverRuntime.server.initStub(o, "tcp/socket"), o);
    }

    public static Object exportObject(Object o, Properties props) throws RemoteException {
        String transportType = props.getProperty("ubik.rmi.transport.type");
        if (transportType == null) {
            transportType = System.getProperty("ubik.rmi.transport.type");
        }
        if (transportType == null) {
            throw new RemoteException("ubik.rmi.transport.type property not specified");
        }
        if (!Hub.serverRuntime.server.isInit(transportType)) {
            Hub.serverRuntime.server.init(o, transportType, props);
            ServerRef ref = Hub.serverRuntime.server.getServerRef(transportType);
            return ref.stub;
        }
        return Hub.getStubFor(Hub.serverRuntime.server.initStub(o, transportType), o);
    }

    public static Object exportObject(Object o, String transportType) throws RemoteException {
        if (!Hub.serverRuntime.server.isInit(transportType)) {
            throw new RemoteException("No server was exported for transport: " + transportType);
        }
        return Hub.getStubFor(Hub.serverRuntime.server.initStub(o, transportType), o);
    }

    public static void unexport(Object o) {
        Hub.serverRuntime.objectTable.remove(o);
    }

    public static void unexport(ClassLoader loader) {
        Hub.serverRuntime.objectTable.remove(loader);
    }

    public static Object connect(String host, int port) throws RemoteException {
        return Hub.connect(new TCPAddress(host, port));
    }

    public static Object connect(ServerAddress address) throws RemoteException {
        Object toReturn;
        RmiConnection conn = null;
        try {
            conn = TransportManager.getConnectionsFor(address).acquire();
            try {
                conn.send(new CommandConnect(address.getTransportType()));
            }
            catch (RemoteException e) {
                Connections conns = TransportManager.getConnectionsFor(address);
                conns.clear();
                conn = conns.acquire();
                conn.send(new CommandConnect(address.getTransportType()));
            }
            toReturn = conn.receive();
        }
        catch (ConnectException e) {
            throw new RemoteException("No server at address: " + address, e);
        }
        catch (IOException e) {
            throw new RemoteException("Error connecting to remote server " + address, e);
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException("Could not find class", e);
        }
        finally {
            if (conn != null) {
                TransportManager.getConnectionsFor(address).release(conn);
            }
        }
        if (toReturn instanceof Throwable) {
            if (toReturn instanceof RuntimeException) {
                throw (RuntimeException)toReturn;
            }
            throw new RemoteException("Problem connecting to remote server", (Throwable)toReturn);
        }
        return toReturn;
    }

    public static ServerAddress getServerAddressFor(String transportType) {
        return Hub.serverRuntime.server.getServerAddress(transportType);
    }

    public static Object asRemote(Object o, VmId caller, String transportType) throws RemoteException {
        if (o instanceof Stub) {
            return o;
        }
        return Hub.getStubFor(Hub.asRemoteRef(o, caller, transportType), o);
    }

    public static RemoteRef asRemoteRef(Object o, VmId caller, String transportType) throws RemoteException {
        if (Hub._perf.createRemoteRef.isEnabled()) {
            Hub._perf.createRemoteRef.start();
        }
        if (!Hub.serverRuntime.server.isInit(transportType)) {
            if (Log.isInfo()) {
                Log.info(Hub.class, (Object)("Exporting default server for : " + caller));
            }
            Hub.serverRuntime.server.init(transportType);
        }
        OID oid = ServerTable.generateOID();
        if (Hub._perf.registerRemoteRef.isEnabled()) {
            Hub._perf.registerRemoteRef.start();
        }
        Hub.serverRuntime.gc.registerRef(caller, oid, o);
        if (Hub._perf.registerRemoteRef.isEnabled()) {
            Hub._perf.registerRemoteRef.end();
        }
        if (Hub._perf.instantianteRemoteRef.isEnabled()) {
            Hub._perf.instantianteRemoteRef.start();
        }
        RemoteRefEx ref = new RemoteRefEx(oid, Hub.serverRuntime.server.getServerRef((String)transportType).server.getServerAddress());
        ref.setCallBack(_callback);
        Hub._perf.instantianteRemoteRef.end();
        Hub._perf.createRemoteRef.end();
        return ref;
    }

    public static boolean isShutdown() {
        return _shutdown;
    }

    public static synchronized void shutdown(long timeout) throws InterruptedException {
        if (_shutdown) {
            return;
        }
        Log.warning(Hub.class, (Object)"Shutting down task manager");
        taskMan.shutdown();
        Log.warning(Hub.class, (Object)"Shutting down client runtime");
        clientRuntime.shutdown(timeout);
        Log.warning(Hub.class, (Object)"Shutting down server runtime");
        serverRuntime.shutdown(timeout);
        Log.warning(Hub.class, (Object)"Shutting down event channels");
        EventChannelSingleton.shutdown();
        Log.warning(Hub.class, (Object)"Shutting down transport manager");
        TransportManager.shutdown();
        Log.warning(Hub.class, (Object)"Shut down completed");
        _shutdown = true;
    }

    public static Object getStubFor(RemoteRef ref, Object remote) {
        Class<?>[] cachedInterfaces = ServerTable.getInterfacesFor(remote.getClass());
        if (Hub._perf.createStub.isEnabled()) {
            Hub._perf.createStub.start();
        }
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), cachedInterfaces, (InvocationHandler)ref);
        if (Hub._perf.createStub.isEnabled()) {
            Hub._perf.createStub.end();
        }
        return proxy;
    }

    static void createReference(ServerAddress address, OID oid) throws RemoteException {
        Connections conns = TransportManager.getConnectionsFor(address);
        try {
            Hub.doSend(conns, oid);
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException("could not refer to object: " + oid + "@" + address, e);
        }
        catch (RemoteException e) {
            conns.clear();
            try {
                Hub.doSend(conns, oid);
            }
            catch (Exception e2) {
                throw new RemoteException("could not refer to object: " + oid + "@" + address, e2);
            }
        }
        catch (IOException e) {
            throw new RemoteException("could not refer to object: " + oid + "@" + address, e);
        }
    }

    private static void registerMBeans() throws Exception {
        Log.info(Hub.class, (Object)"Registering MBeans");
        Hub.bind(Hub.clientRuntime.gc.createMBean());
        Hub.bind(Hub.serverRuntime.gc.createMBean());
        Hub.bind(Hub.serverRuntime.objectTable.createMBean());
        Hub.bind(PerfAnalyzer.getInstance().createMBean());
    }

    private static void bind(MBeanContainer cont) throws Exception {
        JmxHelper.registerMBean(cont.getName(), cont.getMBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSend(Connections conns, OID oid) throws RemoteException, IOException, ClassNotFoundException {
        RmiConnection conn = null;
        try {
            conn = conns.acquire();
            conn.send(new CommandRefer(oid));
            conn.receive();
        }
        finally {
            if (conn != null) {
                conns.release(conn);
            }
        }
    }

    static {
        PropUtil props;
        long dumpInterval;
        statsCollector = new StatsCollector();
        taskMan = TaskManagerFactory.createDefaulTaskManager();
        clientRuntime = new ClientRuntime(taskMan);
        serverRuntime = new ServerRuntime(taskMan);
        _perf = new Perf();
        _freeMemory = new FreeMemStatistic();
        _maxMemory = new MaxMemStatistic();
        _totalMemory = new TotalMemStatistic();
        _callback = System.getProperty("ubik.rmi.callback.enabled") != null && System.getProperty("ubik.rmi.callback.enabled").equalsIgnoreCase("true");
        boolean statsEnabled = PerfAnalyzer.getInstance().isEnabled();
        statsCollector.setEnabled(statsEnabled);
        statsCollector.addStat(_freeMemory).addStat(_maxMemory).addStat(_totalMemory);
        if (statsEnabled && (dumpInterval = (props = new PropUtil().addProperties(System.getProperties())).getLongProperty("ubik.rmi.stats.dump.interval", 0L)) > 0L) {
            Task task = new Task(){

                @Override
                public void exec(TaskContext ctx) {
                    statsCollector.dumpStats(System.out);
                    for (Topic topic : PerfAnalyzer.getInstance().getTopics()) {
                        if (!topic.isEnabled()) continue;
                        statsCollector.dumpStat(System.out, topic.getName(), new Double(topic.duration()));
                    }
                }
            };
            taskMan.addTask(new TaskContext("DumpStats", dumpInterval *= 1000L), task);
        }
        try {
            Hub.registerMBeans();
        }
        catch (Exception e) {
            Log.error(Hub.class, (Object)"Could not register MBeans", (Throwable)e);
        }
    }

    static class Perf {
        Topic createRemoteRef = PerfAnalyzer.getInstance().getTopic(Hub.class.getName() + ".CreateRemoteRef");
        Topic instantianteRemoteRef = PerfAnalyzer.getInstance().getTopic(Hub.class.getName() + ".InstantiateRemoteRef");
        Topic registerRemoteRef = PerfAnalyzer.getInstance().getTopic(Hub.class.getName() + ".RegisterRemoteRef");
        Topic createStub = PerfAnalyzer.getInstance().getTopic(Hub.class.getName() + ".CreateStub");

        Perf() {
        }
    }

    static class TotalMemStatistic
    extends Statistic {
        public TotalMemStatistic() {
            super("TotalMemory");
        }

        @Override
        public double getStat() {
            return (double)Runtime.getRuntime().totalMemory() / 1048576.0;
        }
    }

    static class MaxMemStatistic
    extends Statistic {
        public MaxMemStatistic() {
            super("MaxMemory");
        }

        @Override
        public double getStat() {
            return (double)Runtime.getRuntime().maxMemory() / 1048576.0;
        }
    }

    static class FreeMemStatistic
    extends Statistic {
        public FreeMemStatistic() {
            super("FreeMemory");
        }

        @Override
        public double getStat() {
            return (double)Runtime.getRuntime().freeMemory() / 1048576.0;
        }
    }
}

