/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.PrintStream;
import java.util.Date;
import org.sapia.ubik.util.Debug;

public class Log {
    static final int DEBUG = 0;
    static final int INFO = 1;
    static final int WARNING = 2;
    static final int ERROR = 3;
    static final int REPORT = 4;
    private static int _lvl = 3;
    private static final String[] LABELS = new String[]{"debug", "info", "warning", "error"};

    public static final void setDebug() {
        _lvl = 0;
    }

    public static final void setInfo() {
        _lvl = 1;
    }

    public static final void setWarning() {
        _lvl = 2;
    }

    public static final void setError() {
        _lvl = 3;
    }

    public static final void debug(Class caller, Object msg) {
        if (_lvl <= 0) {
            Log.debug(caller.getName(), msg);
        }
    }

    public static final void debug(String caller, Object msg) {
        if (_lvl <= 0) {
            Log.display(caller, msg);
        }
    }

    public static final void info(Class caller, Object msg) {
        if (_lvl <= 1) {
            Log.info(caller.getName(), msg);
        }
    }

    public static final void info(Class caller, Object msg, Throwable t) {
        if (_lvl <= 1) {
            Log.display(caller.getName(), msg, t);
        }
    }

    public static final void info(String caller, Object msg) {
        if (_lvl <= 1) {
            Log.display(caller, msg);
        }
    }

    public static final void warning(Class caller, Object msg) {
        if (_lvl <= 2) {
            Log.warning(caller.getName(), msg);
        }
    }

    public static final void warning(Class caller, Object msg, Throwable err) {
        if (_lvl <= 2) {
            Log.warning(caller.getName(), msg, err);
        }
    }

    public static final void warning(String caller, Object msg) {
        if (_lvl <= 2) {
            Log.display(caller, msg);
        }
    }

    public static final void warning(String caller, Object msg, Throwable err) {
        if (_lvl <= 2) {
            Log.display(caller, msg, err);
        }
    }

    public static final void error(Class caller, Object msg) {
        if (_lvl <= 3) {
            Log.error(caller.getName(), msg);
        }
    }

    public static final void error(String caller, Object msg) {
        if (_lvl <= 3) {
            Log.display(caller, msg);
        }
    }

    public static final void error(Class caller, Object msg, Throwable t) {
        if (_lvl <= 3) {
            Log.error(caller.getName(), msg, t);
        }
    }

    public static final void error(String caller, Object msg, Throwable t) {
        if (_lvl <= 3) {
            Log.display(caller, msg, t);
        }
    }

    public static final void report(Class caller, Object msg) {
        Log.display(caller.getName(), msg);
    }

    public static final void report(String caller, Object msg) {
        Log.display(caller, msg);
    }

    public static boolean isDebug() {
        return _lvl <= 0;
    }

    public static boolean isInfo() {
        return _lvl <= 1;
    }

    public static boolean isWarning() {
        return _lvl <= 2;
    }

    public static boolean isError() {
        return _lvl <= 3;
    }

    public static int getLevel() {
        return _lvl;
    }

    public static Debug getDebugImpl() {
        return new RmiDebug();
    }

    private static void display(String caller, Object msg) {
        if (msg instanceof Throwable) {
            System.out.println("[" + new Date().toString() + "][" + caller + "] " + ((Throwable)msg).getMessage());
            ((Throwable)msg).printStackTrace();
        } else {
            System.out.println("[" + new Date().toString() + "][" + caller + "] " + msg);
        }
    }

    private static void display(String caller, Object msg, Throwable t) {
        System.out.println("[" + new Date().toString() + "][" + caller + "] " + msg + " - " + t.getMessage());
        t.printStackTrace();
    }

    static {
        String label = System.getProperty("ubik.rmi.log.level");
        if (label != null) {
            for (int i = 0; i < LABELS.length; ++i) {
                if (!LABELS[i].equals(label)) continue;
                _lvl = i;
                break;
            }
        }
    }

    static final class RmiDebug
    implements Debug {
        RmiDebug() {
        }

        @Override
        public void out(Class caller, String msg) {
            Log.debug(caller, (Object)msg);
        }

        @Override
        public void out(Class caller, String msg, Throwable err) {
            Log.error(caller, (Object)msg, err);
        }

        @Override
        public PrintStream out() {
            return System.out;
        }

        @Override
        public boolean on() {
            return true;
        }

        @Override
        public void on(boolean on) {
        }
    }
}

