/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OID
implements Externalizable,
Comparable {
    static final long serialVersionUID = 1L;
    private static final Object _unique = new Object();
    private long _id;
    private int _hashCode;
    private String _codebase = System.getProperty("java.rmi.server.codebase");

    public OID() {
    }

    public OID(long id) {
        this._id = id;
        this._hashCode = (int)(id ^ id >>> 32) ^ _unique.hashCode();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object o) {
        try {
            return ((OID)o)._id == this._id && this._hashCode == o.hashCode();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._id = in.readLong();
        this._hashCode = in.readInt();
        this._codebase = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._id);
        out.writeInt(this._hashCode);
        out.writeObject(this._codebase);
    }

    public String getCodebase() {
        return this._codebase;
    }

    public String toString() {
        return new StringBuffer().append("[id=").append(this._id).append(", hashCode=").append(this._hashCode).append("]").toString();
    }

    public int compareTo(Object other) {
        try {
            long diff = this._id - ((OID)other)._id;
            if (diff < 0L) {
                return -1;
            }
            if (diff == 0L) {
                return this._hashCode - other.hashCode();
            }
            return 1;
        }
        catch (ClassCastException e) {
            return -1;
        }
    }
}

