/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.rmi.NoSuchObjectException;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.ObjectTableMBean;
import org.sapia.ubik.rmi.server.perf.Statistic;

public class ObjectTable
implements ObjectTableMBean,
MBeanFactory {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INIT_CAPACITY = 2000;
    Map _refs;
    Statistic _refCount = new RefCountStat();

    ObjectTable() {
        float loadFactor = 0.75f;
        int initCapacity = 2000;
        PropUtil pu = new PropUtil().addProperties(System.getProperties());
        loadFactor = pu.getFloat("ubik.rmi.object-table.load-factor", 0.75f);
        initCapacity = pu.getIntProperty("ubik.rmi.object-table.initial-capacity", 2000);
        this._refs = Collections.synchronizedMap(new HashMap(initCapacity, loadFactor));
        Hub.statsCollector.addStat(this._refCount);
    }

    public synchronized void register(OID oid, Object o) {
        Ref ref;
        if (Log.isDebug()) {
            Log.debug(ObjectTable.class, (Object)("registering: " + oid));
        }
        if ((ref = (Ref)this._refs.get(oid)) == null) {
            ref = new Ref(oid, o);
            this._refs.put(oid, ref);
        }
        ref.inc();
    }

    public synchronized void reference(OID oid) {
        Ref ref;
        if (Log.isDebug()) {
            Log.debug(ObjectTable.class, (Object)("referencing to: " + oid));
        }
        if ((ref = (Ref)this._refs.get(oid)) == null) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("No object reference for: " + oid));
                Log.debug(this.getClass(), (Object)("Current objects: " + this._refs));
            }
            throw new NullPointerException("no object reference for: " + oid);
        }
        ref.inc();
    }

    public synchronized void dereference(OID oid, int decrement) {
        Ref ref = (Ref)this._refs.get(oid);
        if (ref != null) {
            ref.dec(decrement);
            if (ref.count() <= 0) {
                if (Log.isDebug()) {
                    Log.debug(ObjectTable.class, (Object)("dereferencing: " + oid + " - available for GC"));
                }
                this._refs.remove(oid);
                if (ref._obj instanceof Unreferenced) {
                    ((Unreferenced)ref._obj).unreferenced();
                }
            }
        }
    }

    public Object getObjectFor(OID oid) throws NoSuchObjectException {
        Ref ref = (Ref)this._refs.get(oid);
        if (ref != null && ref.count() > 0) {
            return ref.get();
        }
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("No object reference for: " + oid));
            Log.debug(this.getClass(), (Object)("Current objects: " + this._refs));
        }
        throw new NullPointerException("no object reference for: " + oid);
    }

    public boolean remove(Object o) {
        Ref[] refs = this._refs.values().toArray(new Ref[this._refs.size()]);
        boolean removed = false;
        for (int i = 0; i < refs.length; ++i) {
            if (!refs[i]._obj.equals(o)) continue;
            this._refs.remove(refs[i]._oid);
            removed = true;
        }
        return removed;
    }

    public boolean remove(ClassLoader loader) {
        Ref[] refs = this._refs.values().toArray(new Ref[this._refs.size()]);
        boolean removed = false;
        for (int i = 0; i < refs.length; ++i) {
            if (!refs[i]._obj.getClass().getClassLoader().equals(loader)) continue;
            this._refs.remove(refs[i]._oid);
            if (refs[i]._obj instanceof Unreferenced) {
                ((Unreferenced)refs[i]._obj).unreferenced();
            }
            removed = true;
        }
        return removed;
    }

    public int getRefCount(OID oid) {
        Ref ref = (Ref)this._refs.get(oid);
        if (ref == null) {
            return 0;
        }
        return ref.count();
    }

    @Override
    public int getRefCount() {
        Ref[] refs = this._refs.values().toArray(new Ref[this._refs.size()]);
        int total = 0;
        for (int i = 0; i < refs.length; ++i) {
            total += refs[i].count();
        }
        return total;
    }

    public synchronized void clear() {
        this._refs.clear();
    }

    public Map getRefs() {
        return this._refs;
    }

    public synchronized void clear(OID oid) {
        Ref ref = (Ref)this._refs.get(oid);
        if (ref != null) {
            ref._count = 0;
        }
    }

    @Override
    public MBeanContainer createMBean() throws Exception {
        ObjectName name = new ObjectName("sapia.ubik.rmi:type=ObjectTable");
        return new MBeanContainer(name, this);
    }

    protected static class Ref {
        int _count;
        Object _obj;
        OID _oid;

        Ref(OID oid, Object o) {
            this._obj = o;
            this._oid = oid;
        }

        void dec() {
            --this._count;
        }

        void dec(int count) {
            this._count -= count;
            if (this._count < 0) {
                this._count = 0;
            }
        }

        void inc() {
            ++this._count;
        }

        int count() {
            return this._count;
        }

        Object get() {
            return this._obj;
        }
    }

    class RefCountStat
    extends Statistic {
        public RefCountStat() {
            super("ObjectTableRefCount");
        }

        @Override
        public double getStat() {
            if (ObjectTable.this._refs == null) {
                return 0.0;
            }
            return ObjectTable.this._refs.size();
        }
    }
}

