/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.CommandPing;
import org.sapia.ubik.rmi.server.HealthCheck;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.ServerTable;
import org.sapia.ubik.rmi.server.StubContainer;
import org.sapia.ubik.rmi.server.StubContainerBase;
import org.sapia.ubik.rmi.server.StubInvocationHandler;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;

public abstract class RemoteRef
implements StubInvocationHandler,
Externalizable,
HealthCheck {
    static final long serialVersionUID = 1L;
    protected boolean _callBack;
    protected OID _oid;
    protected VmId _vmId = VmId.getInstance();
    protected ServerAddress _serverAddress;
    protected boolean _isFirstVoyage = true;
    protected transient Connections _pool;
    protected transient Object _lock = new Object();

    public RemoteRef() {
    }

    public RemoteRef(OID oid, ServerAddress serverAddress) {
        this();
        this._oid = oid;
        this._serverAddress = serverAddress;
    }

    public boolean isCallBack() {
        return this._callBack;
    }

    @Override
    public OID getOID() {
        return this._oid;
    }

    protected void setCallBack(boolean callBack) {
        this._callBack = callBack;
    }

    @Override
    public abstract Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    public ServerAddress getServerAddress() {
        return this._serverAddress;
    }

    public OID getOid() {
        return this._oid;
    }

    @Override
    public boolean isValid() {
        try {
            return (Boolean)this.sendCommand(new CommandPing());
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public StubContainer toStubContainer(Object proxy) {
        HashSet interfaces = new HashSet();
        ServerTable.appendInterfaces(proxy.getClass(), interfaces);
        String[] names = new String[interfaces.size()];
        int count = 0;
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            names[count++] = ((Class)iter.next()).getName();
        }
        return new StubContainerBase(names, this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._callBack = in.readBoolean();
        this._oid = (OID)in.readObject();
        this._vmId = (VmId)in.readObject();
        this._serverAddress = (ServerAddress)in.readObject();
        this._isFirstVoyage = in.readBoolean();
        this._lock = new Object();
        Hub.clientRuntime.gc.register(this._serverAddress, this._oid, this);
        if (this._isFirstVoyage) {
            this._isFirstVoyage = false;
        } else {
            Hub.createReference(this._serverAddress, this._oid);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._callBack);
        out.writeObject(this._oid);
        out.writeObject(this._vmId);
        out.writeObject(this._serverAddress);
        out.writeBoolean(this._isFirstVoyage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object sendCommand(RMICommand cmd) throws Throwable {
        Object object = this._lock;
        synchronized (object) {
            if (this._pool == null) {
                this.initPool(false);
            }
        }
        RmiConnection conn = this._pool.acquire();
        try {
            Object object2;
            try {
                conn.send(cmd);
            }
            catch (RemoteException e) {
                object2 = this._lock;
                synchronized (object2) {
                    this._pool.clear();
                }
                conn = this._pool.acquire();
                conn.send(cmd);
            }
            Object toReturn = conn.receive();
            if (toReturn == null) {
                object2 = toReturn;
                return object2;
            }
            if (toReturn instanceof Throwable) {
                Throwable err = (Throwable)toReturn;
                err.fillInStackTrace();
                throw err;
            }
            object2 = toReturn;
            return object2;
        }
        finally {
            this._pool.release(conn);
        }
    }

    protected synchronized void initPool(boolean force) throws RemoteException {
        if (this._pool == null) {
            this._pool = TransportManager.getConnectionsFor(this._serverAddress);
        } else if (force) {
            this._pool.clear();
            this._pool = TransportManager.getConnectionsFor(this._serverAddress);
        }
    }
}

