/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.lang.reflect.Method;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.ClientRuntime;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RemoteRef;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.invocation.CallBackInvokeCommand;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;

public class RemoteRefEx
extends RemoteRef {
    static final long serialVersionUID = 1L;

    public RemoteRefEx() {
    }

    public RemoteRefEx(OID oid, ServerAddress serverAddress) {
        super(oid, serverAddress);
    }

    @Override
    public Object invoke(Object proxy, Method toCall, Object[] params) throws Throwable {
        Object toReturn = null;
        if (this._callBack && Hub.clientRuntime.isCallback(this._serverAddress.getTransportType())) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("invoking (callback) method " + toCall + " on vmId: " + this._vmId));
            }
            if (this._pool == null) {
                super.initPool(false);
            }
            toReturn = ClientRuntime.invoker.dispatchInvocation(this._vmId, this._pool, new CallBackInvokeCommand(this._oid, toCall.getName(), params, toCall.getParameterTypes(), this._serverAddress.getTransportType()));
        } else {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("invoking (no callback) method " + toCall + " on vmId: " + this._vmId));
            }
            if (this._pool == null) {
                super.initPool(false);
            }
            toReturn = ClientRuntime.invoker.dispatchInvocation(this._vmId, this._pool, new InvokeCommand(this._oid, toCall.getName(), params, toCall.getParameterTypes(), this._serverAddress.getTransportType()));
        }
        if (toReturn == null) {
            return toReturn;
        }
        if (toReturn instanceof Throwable) {
            if (toReturn instanceof ShutdownException) {
                this.onShutdown(proxy, toCall, params);
            }
            Throwable err = (Throwable)toReturn;
            err.fillInStackTrace();
            throw err;
        }
        return toReturn;
    }

    protected Object onShutdown(Object proxy, Method toCall, Object[] params) throws Throwable {
        throw new ShutdownException();
    }
}

