/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.naming.ServiceLocator;
import org.sapia.ubik.rmi.server.HealthCheck;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RemoteRef;
import org.sapia.ubik.rmi.server.RemoteRefEx;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.Stub;

public class RemoteRefReliable
extends RemoteRefEx
implements HealthCheck {
    static final long serialVersionUID = 1L;
    protected String _url;

    public RemoteRefReliable() {
    }

    public RemoteRefReliable(OID oid, ServerAddress serverAddress) {
        super(oid, serverAddress);
    }

    public void setUp(String url) {
        this._url = url;
    }

    @Override
    public Object invoke(Object obj, Method toCall, Object[] params) throws Throwable {
        try {
            return super.invoke(obj, toCall, params);
        }
        catch (RemoteException e) {
            if (this._url != null) {
                return this.doFailOver(obj, toCall, params, e);
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._url = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._url);
    }

    @Override
    protected Object onShutdown(Object proxy, Method toCall, Object[] params) throws Throwable {
        return this.doFailOver(proxy, toCall, params, new ShutdownException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object doFailOver(Object obj, Method toCall, Object[] params, Throwable err) throws Throwable {
        try {
            Object remote = ServiceLocator.lookup(this._url);
            if (remote instanceof Stub && Proxy.isProxyClass(remote.getClass())) {
                try {
                    Object object = this._lock;
                    synchronized (object) {
                        ServerAddress newAddr = ((RemoteRef)Proxy.getInvocationHandler(remote)).getServerAddress();
                        this._oid = ((RemoteRef)Proxy.getInvocationHandler(remote)).getOid();
                        if (!((Object)newAddr).equals(this._serverAddress)) {
                            this._serverAddress = newAddr;
                            this.initPool(true);
                        } else {
                            this._pool.clear();
                        }
                    }
                    Hub.clientRuntime.gc.register(this._serverAddress, this._oid, this);
                }
                catch (ClassCastException e) {
                    throw err;
                }
                return super.invoke(obj, toCall, params);
            }
            throw err;
        }
        catch (NamingException e) {
            throw err;
        }
    }
}

