/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Name;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.ClientRuntime;
import org.sapia.ubik.rmi.server.CommandPing;
import org.sapia.ubik.rmi.server.HealthCheck;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.RemoteRef;
import org.sapia.ubik.rmi.server.ServerTable;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.StatelessStubTable;
import org.sapia.ubik.rmi.server.StubContainer;
import org.sapia.ubik.rmi.server.StubContainerBase;
import org.sapia.ubik.rmi.server.StubInvocationHandler;
import org.sapia.ubik.rmi.server.UIDGenerator;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.invocation.CallBackInvokeCommand;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;

public class RemoteRefStateless
implements StubInvocationHandler,
Externalizable,
HealthCheck {
    static final long serialVersionUID = 1L;
    protected Name _name;
    protected String _domain;
    protected String _mcastAddress;
    protected int _mcastPort;
    protected OID _oid = new OID(UIDGenerator.createdUID());
    protected transient boolean _isRegistered;
    protected List _serviceInfos = Collections.synchronizedList(new LinkedList());

    public RemoteRefStateless() {
    }

    public RemoteRefStateless(Name name, String domain) {
        this._name = name;
        this._domain = domain;
    }

    @Override
    public OID getOID() {
        return this._oid;
    }

    @Override
    public Object invoke(Object obj, Method toCall, Object[] params) throws Throwable {
        Object toReturn = null;
        ServiceInfo info = this.acquire();
        try {
            toReturn = this.doInvoke(info, obj, toCall, params);
        }
        catch (ShutdownException e) {
            toReturn = this.handleError(info, obj, toCall, params, e);
        }
        catch (RemoteException e) {
            toReturn = this.handleError(info, obj, toCall, params, e);
        }
        return toReturn;
    }

    @Override
    public boolean isValid() {
        try {
            return this.clean();
        }
        catch (Throwable t) {
            Log.error(this.getClass(), (Object)"Stub not valid", t);
            return false;
        }
    }

    @Override
    public StubContainer toStubContainer(Object proxy) {
        HashSet interfaces = new HashSet();
        ServerTable.appendInterfaces(proxy.getClass(), interfaces);
        String[] names = new String[interfaces.size()];
        int count = 0;
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            names[count++] = ((Class)iter.next()).getName();
        }
        return new StubContainerBase(names, this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = (Name)in.readObject();
        this._domain = in.readUTF();
        this._mcastAddress = in.readUTF();
        this._mcastPort = in.readInt();
        this._oid = (OID)in.readObject();
        this._serviceInfos = (List)in.readObject();
        for (int i = 0; i < this._serviceInfos.size(); ++i) {
            ServiceInfo info = (ServiceInfo)this._serviceInfos.get(i);
            this.processServiceInfo(info);
        }
        if (Log.isInfo()) {
            Log.info(this.getClass(), (Object)("Deserializing stateless stub; endpoints: " + this._serviceInfos));
        }
        StatelessStubTable.registerStatelessRef(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        out.writeUTF(this._domain);
        out.writeUTF(this._mcastAddress);
        out.writeInt(this._mcastPort);
        out.writeObject(this._oid);
        out.writeObject(this._serviceInfos);
    }

    public static RemoteRefStateless fromRemoteRefs(Name name, String domain, List remoteRefs) {
        RemoteRefStateless ref = new RemoteRefStateless(name, domain);
        String mcastAddress = "231.173.5.7";
        int mcastPort = 5454;
        try {
            if (System.getProperty("ubik.rmi.naming.mcast.post") != null) {
                mcastPort = Integer.parseInt(System.getProperty("ubik.rmi.naming.mcast.post"));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (System.getProperty("ubik.rmi.naming.mcast.address") != null) {
            mcastAddress = System.getProperty("ubik.rmi.naming.mcast.address");
        }
        for (int i = 0; i < remoteRefs.size(); ++i) {
            RemoteRef current = (RemoteRef)remoteRefs.get(i);
            if (ref._serviceInfos.contains(current)) continue;
            ServiceInfo info = new ServiceInfo(current._serverAddress, current._oid, current._callBack, current._vmId, current._isFirstVoyage);
            ref._serviceInfos.add(info);
            ref._mcastAddress = mcastAddress;
            ref._mcastPort = mcastPort;
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSibling(RemoteRefStateless other) {
        if (other._oid.equals(this._oid)) {
            return;
        }
        List list = this._serviceInfos;
        synchronized (list) {
            for (int i = 0; i < other._serviceInfos.size(); ++i) {
                ServiceInfo toAdd = (ServiceInfo)other._serviceInfos.get(i);
                if (this._serviceInfos.contains(toAdd)) continue;
                Log.info(this.getClass(), (Object)("Remote server " + other + "added to stateless stub: " + this.toString() + " for name:  " + other._name));
                this._serviceInfos.add(toAdd);
            }
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("Got " + this._serviceInfos.size() + " endpoints : " + this._serviceInfos));
            }
        }
    }

    List getInfos() {
        return this._serviceInfos;
    }

    public int hashCode() {
        return this._oid.hashCode();
    }

    public boolean equals(Object o) {
        try {
            return this == o || ((RemoteRefStateless)o)._oid.equals(this._oid);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return this._serviceInfos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clean() {
        List list = this._serviceInfos;
        synchronized (list) {
            for (int i = 0; i < this._serviceInfos.size(); ++i) {
                ServiceInfo info = (ServiceInfo)this._serviceInfos.get(i);
                Connections pool = null;
                RmiConnection conn = null;
                try {
                    pool = TransportManager.getConnectionsFor(info.address);
                    conn = pool.acquire();
                    conn.send(new CommandPing());
                    conn.receive();
                    pool.release(conn);
                    continue;
                }
                catch (RemoteException e) {
                    this._serviceInfos.remove(i--);
                    Log.info(this.getClass(), (Object)("Cleaning up invalid endpoint: " + info.address));
                    if (pool != null) {
                        pool.clear();
                    }
                    if (conn == null) continue;
                    conn.close();
                    continue;
                }
                catch (Exception e) {
                    Log.error(this.getClass(), (Object)e);
                    if (conn == null) continue;
                    conn.close();
                }
            }
        }
        return this._serviceInfos.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object sendCommand(RMICommand cmd) throws Throwable {
        ServiceInfo info = this.acquire();
        Connections pool = TransportManager.getConnectionsFor(info.address);
        RmiConnection conn = null;
        Object toReturn = null;
        try {
            while (this._serviceInfos.size() > 0) {
                try {
                    conn = pool.acquire();
                    conn.send(cmd);
                    toReturn = conn.receive();
                    if (!(toReturn instanceof ShutdownException)) break;
                    pool.clear();
                    info = this.removeAcquire(info);
                    pool = TransportManager.getConnectionsFor(info.address);
                }
                catch (RemoteException e) {
                    pool.clear();
                    try {
                        conn = pool.acquire();
                        conn.send(new CommandPing());
                        conn.receive();
                    }
                    catch (RemoteException e2) {
                        if (Log.isInfo()) {
                            Log.info(this.getClass(), (Object)("Invalid endpoint for stateless stub: " + info));
                            Log.info(this.getClass(), (Object)("Got " + this._serviceInfos.size() + " remaining endpoints: " + this._serviceInfos));
                        }
                        pool.clear();
                        info = this.removeAcquire(info);
                        pool = TransportManager.getConnectionsFor(info.address);
                    }
                }
            }
            if (this._serviceInfos.size() == 0 || conn == null) {
                throw new RemoteException("No connection available");
            }
            if (toReturn == null) {
                Object e = toReturn;
                if (conn != null) {
                    pool.release(conn);
                }
                return e;
            }
        }
        catch (Throwable throwable) {
            if (conn != null) {
                pool.release(conn);
            }
            throw throwable;
        }
        {
            if (toReturn instanceof Throwable) {
                Throwable err = (Throwable)toReturn;
                err.fillInStackTrace();
                throw err;
            }
            Object object = toReturn;
            if (conn != null) {
                pool.release(conn);
            }
            return object;
        }
    }

    protected Object doInvoke(ServiceInfo info, Object obj, Method toCall, Object[] params) throws Throwable {
        Connections pool;
        Object toReturn = null;
        if (info.callback && Hub.clientRuntime.isCallback(info.address.getTransportType())) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("invoking (callback): " + toCall));
            }
            pool = TransportManager.getConnectionsFor(info.address);
            toReturn = ClientRuntime.invoker.dispatchInvocation(info.vmId, pool, new CallBackInvokeCommand(info.oid, toCall.getName(), params, toCall.getParameterTypes(), info.address.getTransportType()));
        } else {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("invoking (no callback): " + toCall));
            }
            pool = TransportManager.getConnectionsFor(info.address);
            toReturn = ClientRuntime.invoker.dispatchInvocation(info.vmId, pool, new InvokeCommand(info.oid, toCall.getName(), params, toCall.getParameterTypes(), info.address.getTransportType()));
        }
        if (toReturn == null) {
            return toReturn;
        }
        if (toReturn instanceof Throwable) {
            Throwable err = (Throwable)toReturn;
            err.fillInStackTrace();
            throw err;
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceInfo acquire() throws RemoteException {
        ServiceInfo toReturn;
        if (this._serviceInfos.size() == 0) {
            throw new RemoteException("No connection available");
        }
        List list = this._serviceInfos;
        synchronized (list) {
            toReturn = (ServiceInfo)this._serviceInfos.remove(0);
            this._serviceInfos.add(toReturn);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceInfo removeAcquire(ServiceInfo toRemove) throws RemoteException {
        List list = this._serviceInfos;
        synchronized (list) {
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("Removing invalid instance: " + toRemove.address));
            }
            this._serviceInfos.remove(toRemove);
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("Remaining: " + this._serviceInfos));
            }
        }
        return this.acquire();
    }

    protected Object handleError(ServiceInfo info, Object obj, Method toCall, Object[] params, Throwable err) throws Throwable {
        while (true) {
            info = this.removeAcquire(info);
            try {
                return this.doInvoke(info, obj, toCall, params);
            }
            catch (Throwable t) {
                if (!(t instanceof RemoteException) && !(t instanceof ShutdownException)) continue;
                err = t;
                if ((err instanceof ShutdownException || err instanceof RemoteException) && this._serviceInfos.size() > 0) continue;
                throw err;
            }
            break;
        }
    }

    private void processServiceInfo(ServiceInfo info) throws IOException {
        Hub.clientRuntime.gc.register(info.address, info.oid, this);
        if (info.isFirstVoyage) {
            info.isFirstVoyage = false;
        } else {
            try {
                Hub.createReference(info.address, info.oid);
            }
            catch (RemoteException e) {
                this._serviceInfos.remove(info);
            }
        }
    }

    public static class ServiceInfo
    implements Serializable {
        ServerAddress address;
        OID oid;
        boolean callback;
        boolean isFirstVoyage;
        VmId vmId;

        public ServiceInfo(ServerAddress addr, OID id, boolean callback, VmId vmId, boolean isFirstVoyage) {
            this.address = addr;
            this.oid = id;
            this.callback = callback;
            this.vmId = vmId;
            this.isFirstVoyage = isFirstVoyage;
        }

        public int hashCode() {
            return this.oid.hashCode();
        }

        public boolean equals(Object other) {
            try {
                ServiceInfo otherInfo = (ServiceInfo)other;
                return otherInfo.oid.equals(this.oid);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public String toString() {
            return "[ oid=" + this.oid + ", address=" + this.address + " ]";
        }
    }
}

