/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import org.sapia.ubik.rmi.interceptor.Event;
import org.sapia.ubik.rmi.interceptor.Interceptor;
import org.sapia.ubik.rmi.interceptor.InvalidInterceptorException;
import org.sapia.ubik.rmi.interceptor.MultiDispatcher;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.ObjectTable;
import org.sapia.ubik.rmi.server.ServerTable;
import org.sapia.ubik.rmi.server.gc.ServerGC;
import org.sapia.ubik.rmi.server.invocation.RMICommandProcessor;
import org.sapia.ubik.taskman.TaskManager;

public class ServerRuntime {
    static final int DEFAULT_MAX_CALLBACK_THREADS = 1;
    public final ObjectTable objectTable = new ObjectTable();
    public final MultiDispatcher dispatcher = new MultiDispatcher();
    public final ServerGC gc;
    public final RMICommandProcessor processor;
    public final ServerTable server = new ServerTable();

    ServerRuntime(TaskManager taskman) {
        int maxThreads = 1;
        if (System.getProperty("ubik.rmi.server.callback.max-threads") != null) {
            try {
                maxThreads = System.getProperty("ubik.rmi.callback.enabled") != null && System.getProperty("ubik.rmi.callback.enabled").equalsIgnoreCase("true") ? Integer.parseInt(System.getProperty("ubik.rmi.server.callback.max-threads")) : 1;
            }
            catch (NumberFormatException e) {
                Log.warning(ServerRuntime.class, (Object)("invalid value for system property: ubik.rmi.server.callback.max-threads; using default: " + maxThreads));
            }
        }
        this.processor = new RMICommandProcessor(maxThreads);
        this.gc = new ServerGC(taskman);
    }

    public synchronized void addInterceptor(Class eventClass, Interceptor it) throws InvalidInterceptorException {
        this.dispatcher.addInterceptor(eventClass, it);
    }

    public void dispatchEvent(Event event) {
        this.dispatcher.dispatch(event);
    }

    void shutdown(long timeout) throws InterruptedException {
        Log.warning(ServerRuntime.class, (Object)"Shutting down command processor");
        this.processor.shutdown(timeout);
        Log.warning(ServerRuntime.class, (Object)"Shutting down server");
        this.server.close();
    }
}

