/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sapia.ubik.jmx.JmxHelper;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.Remote;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RemoteRef;
import org.sapia.ubik.rmi.server.RemoteRefEx;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.ServerRef;
import org.sapia.ubik.rmi.server.Stub;
import org.sapia.ubik.rmi.server.UIDGenerator;
import org.sapia.ubik.rmi.server.transport.TransportManager;

public class ServerTable
implements Server {
    static final String DEFAULT_TRANSPORT_TYPE = "tcp/socket";
    private static Map<Class<?>, Class<?>[]> _interfaceCache = new ConcurrentHashMap();
    Map<String, ServerRef> _serversByType = new ConcurrentHashMap<String, ServerRef>();

    @Override
    public void start() {
    }

    @Override
    public void close() {
        for (ServerRef ref : this._serversByType.values()) {
            ref.server.close();
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.getServerRef((String)DEFAULT_TRANSPORT_TYPE).server.getServerAddress();
    }

    public ServerAddress getServerAddress(String transportType) {
        return this.getServerRef((String)transportType).server.getServerAddress();
    }

    public RemoteRef getRemoteRef(String transportType) {
        return this.getServerRef((String)transportType).ref;
    }

    public OID getOID(String transportType) {
        return this.getServerRef((String)transportType).oid;
    }

    boolean isInit(String transportType) {
        return this._serversByType.get(transportType) != null;
    }

    ServerAddress init(Object remote, String transportType) throws RemoteException, IllegalStateException {
        Server s = TransportManager.getProviderFor(transportType).newDefaultServer();
        s.start();
        return this.doInit(remote, s, transportType);
    }

    ServerAddress init(Object remote) throws RemoteException, IllegalStateException {
        return this.init(remote, 0);
    }

    ServerAddress init(Object remote, int port) throws RemoteException, IllegalStateException {
        return this.doInit(remote, port, DEFAULT_TRANSPORT_TYPE);
    }

    ServerAddress init(Object remote, String transportType, Properties props) throws RemoteException, IllegalStateException {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Getting server for transport : " + transportType + ": properties: " + props));
        }
        Server s = TransportManager.getProviderFor(transportType).newServer(props);
        s.start();
        return this.doInit(remote, s, transportType);
    }

    private synchronized ServerAddress doInit(Object remote, int port, String transportType) throws RemoteException, IllegalStateException {
        Server s;
        if (this._serversByType.get(transportType) != null) {
            throw new IllegalStateException("server already created");
        }
        if (Log.isDebug()) {
            Log.debug(ServerTable.class, (Object)"initializing server");
        }
        try {
            s = TransportManager.getDefaultProvider().newServer(port);
        }
        catch (IOException e) {
            throw new RemoteException("could not create singleton server", e);
        }
        s.start();
        return this.doInit(remote, s, transportType);
    }

    private synchronized ServerAddress doInit(Object remote, Server s, String transportType) throws RemoteException, IllegalStateException {
        if (this._serversByType.get(transportType) != null) {
            throw new IllegalStateException("server already created");
        }
        ServerRef serverRef = new ServerRef();
        serverRef.server = s;
        if (Log.isDebug()) {
            Log.debug(ServerTable.class, (Object)("server listening on: " + serverRef.server.getServerAddress()));
        }
        if (remote != null) {
            serverRef.oid = ServerTable.generateOID();
            serverRef.ref = this.initRef(remote, serverRef.oid, serverRef);
            serverRef.stub = (Stub)Hub.getStubFor(serverRef.ref, remote);
        }
        this._serversByType.put(transportType, serverRef);
        if (s instanceof MBeanFactory) {
            try {
                MBeanContainer mbc = ((MBeanFactory)((Object)s)).createMBean();
                JmxHelper.registerMBean(mbc.getName(), mbc.getMBean());
            }
            catch (Exception e) {
                throw new RemoteException("Could not create MBean", e);
            }
        }
        return serverRef.server.getServerAddress();
    }

    final RemoteRef initStub(Object remote, String transportType) {
        return this.initRef(remote, ServerTable.generateOID(), this.getServerRef(transportType));
    }

    static Class<?>[] getInterfacesFor(Class<?> clazz) {
        Class<?>[] cachedInterfaces = _interfaceCache.get(clazz);
        if (cachedInterfaces == null) {
            Class<?> current = clazz;
            Remote remoteAnno = current.getAnnotation(Remote.class);
            if (remoteAnno != null) {
                Class<?>[] remoteInterfaces = remoteAnno.interfaces();
                HashSet set = new HashSet();
                set.add(Stub.class);
                for (Class<?> remoteInterface : remoteInterfaces) {
                    set.add(remoteInterface);
                }
                cachedInterfaces = set.toArray(new Class[set.size()]);
            } else {
                HashSet set = new HashSet();
                ServerTable.appendInterfaces(current, set);
                set.add(Stub.class);
                cachedInterfaces = set.toArray(new Class[set.size()]);
            }
            _interfaceCache.put(clazz, cachedInterfaces);
        }
        return cachedInterfaces;
    }

    static void appendInterfaces(Class<?> current, Set<Class<?>> interfaces) {
        Class<?>[] ifs = current.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            ServerTable.appendInterfaces(ifs[i], interfaces);
            interfaces.add(ifs[i]);
        }
        if ((current = current.getSuperclass()) != null) {
            ServerTable.appendInterfaces(current, interfaces);
        }
    }

    ServerRef getServerRef(String transportType) throws IllegalArgumentException {
        ServerRef ref = this._serversByType.get(transportType);
        if (ref == null) {
            throw new IllegalStateException("No server for type: " + transportType);
        }
        return ref;
    }

    static synchronized OID generateOID() {
        return new OID(UIDGenerator.createdUID());
    }

    private final RemoteRef initRef(Object remote, OID oid, ServerRef serverRef) {
        RemoteRefEx rmiHandler = new RemoteRefEx(oid, serverRef.server.getServerAddress());
        rmiHandler.setCallBack(System.getProperty("ubik.rmi.callback.enabled") != null && System.getProperty("ubik.rmi.callback.enabled").equalsIgnoreCase("true"));
        if (Log.isDebug()) {
            Log.debug(ServerTable.class, (Object)(remote + " is call-back: " + rmiHandler.isCallBack()));
        }
        Hub.serverRuntime.objectTable.register(oid, remote);
        return rmiHandler;
    }
}

