/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sapia.ubik.mcast.AsyncEventListener;
import org.sapia.ubik.mcast.EventChannel;
import org.sapia.ubik.mcast.RemoteEvent;
import org.sapia.ubik.rmi.naming.remote.archie.SyncPutEvent;
import org.sapia.ubik.rmi.server.EventChannelSingleton;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RemoteRefStateless;
import org.sapia.ubik.rmi.server.Stub;
import org.sapia.ubik.rmi.server.StubContainer;
import org.sapia.ubik.rmi.server.StubInvocationHandler;

public class StatelessStubTable
implements AsyncEventListener {
    private static Map _stubs = Collections.synchronizedMap(new HashMap());
    private static StatelessStubTable _instance = new StatelessStubTable();

    StatelessStubTable() {
    }

    public static synchronized void registerStatelessRef(RemoteRefStateless ref) {
        EventChannel channel;
        if (Log.isInfo()) {
            Log.info(StatelessStubTable.class, (Object)"Registering stateless stub");
        }
        if (!(channel = EventChannelSingleton.getEventChannelFor(ref._domain, ref._mcastAddress, ref._mcastPort)).containsAsyncListener(_instance)) {
            channel.registerAsyncListener(SyncPutEvent.class.getName(), _instance);
        }
        ref.clean();
        StatelessStubTable.doRegister(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAsyncEvent(RemoteEvent evt) {
        block14: {
            try {
                Object bound;
                if (Log.isInfo()) {
                    Log.info(this.getClass(), (Object)("Remote binding event received: " + evt.getType()));
                }
                SyncPutEvent bEvt = (SyncPutEvent)evt.getData();
                try {
                    bound = bEvt.getValue();
                }
                catch (IOException e) {
                    Log.error(this.getClass(), (Object)"Error receiving bound object", (Throwable)e);
                    return;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    Log.error(this.getClass(), (Object)"Error receiving bound object", (Throwable)e);
                    return;
                }
                StubInvocationHandler handler = null;
                if (bound instanceof StubContainer) {
                    handler = ((StubContainer)bound).getStubInvocationHandler();
                } else if (Proxy.isProxyClass(bound.getClass()) && bound instanceof Stub) {
                    handler = (StubInvocationHandler)Proxy.getInvocationHandler(bound);
                }
                if (handler == null || !(handler instanceof RemoteRefStateless)) break block14;
                RemoteRefStateless other = (RemoteRefStateless)handler;
                Map map = _stubs;
                synchronized (map) {
                    ArrayList siblings = (ArrayList)_stubs.get(other._domain);
                    if (siblings == null) {
                        siblings = new ArrayList();
                        _stubs.put(other._domain, siblings);
                    }
                    StatelessStubTable.addSiblings(siblings, other);
                }
            }
            catch (IOException e) {
                Log.error(this.getClass(), (Object)e);
            }
            catch (RuntimeException e) {
                Log.error(this.getClass(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void doRegister(RemoteRefStateless ref) {
        Map map = _stubs;
        synchronized (map) {
            ArrayList<SoftReference<RemoteRefStateless>> siblings = (ArrayList<SoftReference<RemoteRefStateless>>)_stubs.get(ref._domain);
            if (siblings == null) {
                siblings = new ArrayList<SoftReference<RemoteRefStateless>>();
                _stubs.put(ref._domain, siblings);
            }
            siblings.add(new SoftReference<RemoteRefStateless>(ref));
            StatelessStubTable.addSiblings(siblings, ref);
        }
    }

    static List getSiblings(String domain) {
        return (List)_stubs.get(domain);
    }

    private static void addSiblings(List siblings, RemoteRefStateless other) {
        for (int i = 0; i < siblings.size(); ++i) {
            SoftReference ref = (SoftReference)siblings.get(i);
            RemoteRefStateless remoteRef = (RemoteRefStateless)ref.get();
            if (remoteRef == null) {
                siblings.remove(i--);
                continue;
            }
            if (!remoteRef._name.equals(other._name) || remoteRef._oid.equals(other._oid)) continue;
            Log.info(StatelessStubTable.class, (Object)("Binding received for name: " + other._name));
            if (remoteRef.clean()) {
                other.addSibling(remoteRef);
            }
            remoteRef.addSibling(other);
        }
    }
}

