/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import org.sapia.ubik.rmi.server.HealthCheck;
import org.sapia.ubik.rmi.server.RmiClassLoader;
import org.sapia.ubik.rmi.server.StubContainer;
import org.sapia.ubik.rmi.server.StubInvocationHandler;

public class StubContainerBase
implements StubContainer,
HealthCheck {
    private StubInvocationHandler _ref;
    private String[] _interfaceNames;
    private static final boolean CODE_DOWNLOAD = System.getProperty("ubik.rmi.code-download.enabled") != null && System.getProperty("ubik.rmi.code-download.enabled").equals("true");

    protected StubContainerBase(String[] interfaceNames, StubInvocationHandler handler) {
        this._ref = handler;
        this._interfaceNames = interfaceNames;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (this._ref instanceof HealthCheck) {
            return ((HealthCheck)((Object)this._ref)).isValid();
        }
        return true;
    }

    @Override
    public Object toStub(ClassLoader loader) throws RemoteException {
        Class[] interfaces = new Class[this._interfaceNames.length];
        if (this._ref.getOID().getCodebase() != null && CODE_DOWNLOAD) {
            loader = new RmiClassLoader(loader, this._ref.getOID().getCodebase());
        }
        for (int i = 0; i < this._interfaceNames.length; ++i) {
            try {
                interfaces[i] = loader.loadClass(this._interfaceNames[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RemoteException("Could not find interface definition: " + this._interfaceNames[i], e);
            }
        }
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this._ref);
    }

    @Override
    public StubInvocationHandler getStubInvocationHandler() {
        return this._ref;
    }

    public String toString() {
        return this._ref.toString();
    }
}

